/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.recovery.partitions.restart;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.recovery.restart.RestartPartitionsCall;
import org.apache.ignite.internal.cli.call.recovery.restart.RestartPartitionsCallInput;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.commands.recovery.partitions.restart.RestartPartitionsMixin;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="restart", description={"Restarts partitions."})
public class RestartPartitionsReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private RestartPartitionsMixin options;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private RestartPartitionsCall call;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(url -> RestartPartitionsCallInput.of(this.options, url)).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot restart partitions")).print());
    }
}

