/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.Ignite;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofTable;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;

class RestartProofIgniteCatalog
implements IgniteCatalog,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteCatalog(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    public CompletableFuture<Table> createTableAsync(Class<?> recordClass) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createTableAsync(recordClass).thenApply(table -> this.wrapTable((Table)table, (Ignite)ignite)));
    }

    public CompletableFuture<Table> createTableAsync(Class<?> keyClass, Class<?> valueClass) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createTableAsync(keyClass, valueClass).thenApply(table -> this.wrapTable((Table)table, (Ignite)ignite)));
    }

    public CompletableFuture<Table> createTableAsync(TableDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createTableAsync(definition).thenApply(table -> this.wrapTable((Table)table, (Ignite)ignite)));
    }

    public Table createTable(Class<?> recordClass) {
        return this.attachmentLock.attached(ignite -> {
            Table table = ignite.catalog().createTable(recordClass);
            return this.wrapTable(table, (Ignite)ignite);
        });
    }

    public Table createTable(Class<?> keyClass, Class<?> valueClass) {
        return this.attachmentLock.attached(ignite -> {
            Table table = ignite.catalog().createTable(keyClass, valueClass);
            return this.wrapTable(table, (Ignite)ignite);
        });
    }

    public Table createTable(TableDefinition definition) {
        return this.attachmentLock.attached(ignite -> {
            Table table = ignite.catalog().createTable(definition);
            return this.wrapTable(table, (Ignite)ignite);
        });
    }

    public CompletableFuture<TableDefinition> tableDefinitionAsync(QualifiedName tableName) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().tableDefinitionAsync(tableName));
    }

    public TableDefinition tableDefinition(QualifiedName tableName) {
        return this.attachmentLock.attached(ignite -> ignite.catalog().tableDefinition(tableName));
    }

    private Table wrapTable(Table table, Ignite ignite) {
        return new RestartProofTable(this.attachmentLock, ignite, RestartProofTable.tableId(table));
    }

    public CompletableFuture<Void> createZoneAsync(ZoneDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createZoneAsync(definition));
    }

    public void createZone(ZoneDefinition definition) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().createZone(definition));
    }

    public CompletableFuture<ZoneDefinition> zoneDefinitionAsync(String zoneName) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().zoneDefinitionAsync(zoneName));
    }

    public ZoneDefinition zoneDefinition(String zoneName) {
        return this.attachmentLock.attached(ignite -> ignite.catalog().zoneDefinition(zoneName));
    }

    public CompletableFuture<Void> dropTableAsync(TableDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropTableAsync(definition));
    }

    public CompletableFuture<Void> dropTableAsync(QualifiedName name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropTableAsync(name));
    }

    public void dropTable(TableDefinition definition) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropTable(definition));
    }

    public void dropTable(QualifiedName name) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropTable(name));
    }

    public CompletableFuture<Void> dropZoneAsync(ZoneDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropZoneAsync(definition));
    }

    public CompletableFuture<Void> dropZoneAsync(String name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropZoneAsync(name));
    }

    public void dropZone(ZoneDefinition definition) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropZone(definition));
    }

    public void dropZone(String name) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropZone(name));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap((Object)ignite.catalog(), (Class)classToUnwrap));
    }
}

