/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.hash;

import java.util.Objects;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite.internal.pagememory.util.GradualTask;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.index.AbstractPageMemoryIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexTree;
import org.apache.ignite.internal.storage.pagememory.index.hash.InsertHashIndexRowInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.index.hash.RemoveHashIndexRowInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.util.StorageState;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PageMemoryHashIndexStorage
extends AbstractPageMemoryIndexStorage<HashIndexRowKey, HashIndexRow, HashIndexTree>
implements HashIndexStorage {
    @Nullable
    private final StorageHashIndexDescriptor descriptor;

    public PageMemoryHashIndexStorage(IndexMeta indexMeta, @Nullable StorageHashIndexDescriptor descriptor, FreeListImpl freeList, HashIndexTree indexTree, IndexMetaTree indexMetaTree, boolean isVolatile) {
        super(indexMeta, indexTree.partitionId(), indexTree, freeList, indexMetaTree, isVolatile);
        this.descriptor = descriptor;
    }

    public StorageHashIndexDescriptor indexDescriptor() {
        assert (this.descriptor != null) : "This tree must only be used during recovery";
        return this.descriptor;
    }

    @TestOnly
    HashIndexTree indexTree() {
        return (HashIndexTree)this.indexTree;
    }

    @TestOnly
    FreeListImpl freeList() {
        return this.freeList;
    }

    public Cursor<RowId> get(final BinaryTuple key) throws StorageException {
        return (Cursor)this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((StorageState)this.state.get()), () -> this.createStorageInfo());
            this.throwExceptionIfIndexIsNotBuilt();
            IndexColumns indexColumns = new IndexColumns(this.partitionId, key.byteBuffer());
            HashIndexRow lowerBound = new HashIndexRow(indexColumns, this.lowestRowId);
            return new AbstractPageMemoryIndexStorage.ScanCursor<RowId>((HashIndexRowKey)lowerBound){

                @Override
                protected RowId map(HashIndexRow value) {
                    return value.rowId();
                }

                @Override
                protected boolean exceedsUpperBound(HashIndexRow value) {
                    return !Objects.equals(value.indexColumns().valueBuffer(), key.byteBuffer());
                }
            };
        });
    }

    public void put(IndexRow row) throws StorageException {
        this.busyNonDataRead(() -> {
            try {
                IndexColumns indexColumns = new IndexColumns(this.partitionId, row.indexColumns().byteBuffer());
                HashIndexRow hashIndexRow = new HashIndexRow(indexColumns, row.rowId());
                HashIndexTree tree = (HashIndexTree)this.indexTree;
                InsertHashIndexRowInvokeClosure insert = new InsertHashIndexRowInvokeClosure(hashIndexRow, this.freeList, tree.inlineSize());
                tree.invoke(hashIndexRow, null, insert);
                return null;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to put value into index", (Throwable)e);
            }
        });
    }

    public void remove(IndexRow row) throws StorageException {
        this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((StorageState)this.state.get()), () -> this.createStorageInfo());
            try {
                IndexColumns indexColumns = new IndexColumns(this.partitionId, row.indexColumns().byteBuffer());
                HashIndexRow hashIndexRow = new HashIndexRow(indexColumns, row.rowId());
                RemoveHashIndexRowInvokeClosure remove = new RemoveHashIndexRowInvokeClosure(hashIndexRow, this.freeList);
                ((HashIndexTree)this.indexTree).invoke(hashIndexRow, null, remove);
                remove.afterCompletion();
                return null;
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to remove value from index", (Throwable)e);
            }
        });
    }

    @Override
    protected GradualTask createDestructionTask(int maxWorkUnits) throws IgniteInternalCheckedException {
        return ((HashIndexTree)this.indexTree).startGradualDestruction(rowKey -> this.removeIndexColumns((HashIndexRow)rowKey), false, maxWorkUnits);
    }

    private void removeIndexColumns(HashIndexRow indexRow) {
        if (indexRow.indexColumns().link() != 0L) {
            try {
                this.freeList.removeDataRowByLink(indexRow.indexColumns().link());
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Cannot destroy hash index " + this.indexDescriptor().id(), (Throwable)e);
            }
            indexRow.indexColumns().link(0L);
        }
    }
}

