/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.CompletedPart;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.multipart.Attribute;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;

@Internal
public class NettyCompletedAttribute
implements CompletedPart {
    private final Attribute attribute;
    private final boolean controlRelease;

    public NettyCompletedAttribute(Attribute attribute) {
        this(attribute, true);
    }

    NettyCompletedAttribute(Attribute attribute, boolean controlRelease) {
        this.attribute = attribute;
        this.controlRelease = controlRelease;
    }

    public String getName() {
        return this.attribute.getName();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteBufInputStream(this.attribute.getByteBuf(), this.controlRelease);
    }

    public byte[] getBytes() throws IOException {
        ByteBuf byteBuf = this.attribute.getByteBuf();
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            return byArray;
        }
        finally {
            if (this.controlRelease) {
                this.attribute.release();
            }
        }
    }

    public ByteBuffer getByteBuffer() throws IOException {
        ByteBuf byteBuf = this.attribute.getByteBuf();
        try {
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            return byteBuffer;
        }
        finally {
            if (this.controlRelease) {
                this.attribute.release();
            }
        }
    }

    public Optional<MediaType> getContentType() {
        return Optional.empty();
    }
}

