/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.metrics.sources;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.MetricSetBuilder;
import org.apache.ignite.shaded.org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class JvmMetricSource
implements MetricSource {
    private static final String SOURCE_NAME = "jvm";
    private static final long MEMORY_USAGE_CACHE_TIMEOUT = 1000L;
    private final MemoryMXBean memoryMxBean;
    private final List<GarbageCollectorMXBean> gcMxBeans;
    private final RuntimeMXBean runtimeBean;
    private boolean enabled;

    JvmMetricSource(RuntimeMXBean runtimeBean, MemoryMXBean memoryMxBean, List<GarbageCollectorMXBean> gcMxBeans) {
        this.runtimeBean = runtimeBean;
        this.memoryMxBean = memoryMxBean;
        this.gcMxBeans = List.copyOf(gcMxBeans);
    }

    public JvmMetricSource() {
        this.memoryMxBean = ManagementFactory.getMemoryMXBean();
        this.gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.runtimeBean = ManagementFactory.getRuntimeMXBean();
    }

    @Override
    public String name() {
        return SOURCE_NAME;
    }

    @Override
    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        MetricSetBuilder metricSetBuilder = new MetricSetBuilder(SOURCE_NAME);
        CachedMemoryUsage heapMemoryUsage = new CachedMemoryUsage(this.memoryMxBean::getHeapMemoryUsage, 1000L);
        metricSetBuilder.longGauge("memory.heap.Init", "Initial amount of heap memory", () -> heapMemoryUsage.get().getInit());
        metricSetBuilder.longGauge("memory.heap.Used", "Current used amount of heap memory", () -> heapMemoryUsage.get().getUsed());
        metricSetBuilder.longGauge("memory.heap.Committed", "Committed amount of heap memory", () -> heapMemoryUsage.get().getCommitted());
        metricSetBuilder.longGauge("memory.heap.Max", "Maximum amount of heap memory", () -> heapMemoryUsage.get().getMax());
        CachedMemoryUsage nonHeapMemoryUsage = new CachedMemoryUsage(this.memoryMxBean::getNonHeapMemoryUsage, 1000L);
        metricSetBuilder.longGauge("memory.non-heap.Init", "Initial amount of non-heap memory", () -> nonHeapMemoryUsage.get().getInit());
        metricSetBuilder.longGauge("memory.non-heap.Used", "Used amount of non-heap memory", () -> nonHeapMemoryUsage.get().getUsed());
        metricSetBuilder.longGauge("memory.non-heap.Committed", "Committed amount of non-heap memory", () -> nonHeapMemoryUsage.get().getCommitted());
        metricSetBuilder.longGauge("memory.non-heap.Max", "Maximum amount of non-heap memory", () -> nonHeapMemoryUsage.get().getMax());
        metricSetBuilder.longGauge("gc.CollectionTime", "Approximate total time spent on garbage collection in milliseconds, summed across all collectors.", this::totalCollectionTime);
        metricSetBuilder.longGauge("UpTime", "The uptime of the Java virtual machine in milliseconds.", this.runtimeBean::getUptime);
        this.enabled = true;
        return metricSetBuilder.build();
    }

    private long totalCollectionTime() {
        long total = 0L;
        for (GarbageCollectorMXBean gcMxBean : this.gcMxBeans) {
            long time = gcMxBean.getCollectionTime();
            if (time <= 0L) continue;
            total += time;
        }
        return total;
    }

    @Override
    public synchronized void disable() {
        this.enabled = false;
    }

    @Override
    public synchronized boolean enabled() {
        return this.enabled;
    }

    private static class CachedMemoryUsage {
        private final Supplier<MemoryUsage> source;
        private final long timeout;
        private volatile long lastUpdateTime;
        private volatile MemoryUsage currentVal;

        private CachedMemoryUsage(Supplier<MemoryUsage> source, long timeout) {
            this.source = source;
            this.timeout = timeout;
            this.update();
        }

        private MemoryUsage get() {
            if (System.currentTimeMillis() - this.lastUpdateTime > this.timeout) {
                this.update();
            }
            return this.currentVal;
        }

        private synchronized void update() {
            this.currentVal = this.source.get();
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

