/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;

public class JdbcPrimaryKeyMeta
implements ClientMessage {
    private String schemaName;
    private String tblName;
    private String name;
    private List<String> fields;

    public JdbcPrimaryKeyMeta() {
    }

    public JdbcPrimaryKeyMeta(String schemaName, String tblName, String name, List<String> fields) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.name = name;
        this.fields = fields;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String name() {
        return this.name;
    }

    public List<String> fields() {
        return this.fields;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        packer.packString(this.schemaName);
        packer.packString(this.tblName);
        packer.packString(this.name);
        if (this.fields == null || this.fields.isEmpty()) {
            packer.packNil();
        }
        packer.packInt(this.fields.size());
        for (String field : this.fields) {
            packer.packString(field);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.schemaName = unpacker.unpackString();
        this.tblName = unpacker.unpackString();
        this.name = unpacker.unpackString();
        if (unpacker.tryUnpackNil()) {
            this.fields = Collections.emptyList();
            return;
        }
        int size = unpacker.unpackInt();
        this.fields = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            this.fields.add(unpacker.unpackString());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcPrimaryKeyMeta meta = (JdbcPrimaryKeyMeta)o;
        return Objects.equals(this.schemaName, meta.schemaName) && Objects.equals(this.tblName, meta.tblName) && Objects.equals(this.name, meta.name) && Objects.equals(this.fields, meta.fields);
    }

    public int hashCode() {
        int result = this.schemaName.hashCode();
        result = 31 * result + this.tblName.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        return result;
    }

    public String toString() {
        return S.toString(JdbcPrimaryKeyMeta.class, this);
    }
}

