/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.impl.io.IdentityOutputStream;
import org.apache.hc.core5.http.impl.io.SessionOutputBufferImpl;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestIdentityOutputStream {
    TestIdentityOutputStream() {
    }

    @Test
    void testBasics() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        try (IdentityOutputStream out = new IdentityOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream);){
            byte[] tmp = new byte[10];
            out.write(tmp, 0, 10);
            out.write(tmp);
            out.write(1);
            out.flush();
        }
        byte[] data = outputStream.toByteArray();
        Assertions.assertEquals((int)21, (int)data.length);
    }

    @Test
    void testClose() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        IdentityOutputStream out = new IdentityOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream);
        out.close();
        out.close();
        byte[] tmp = new byte[10];
        Assertions.assertThrows(IOException.class, () -> TestIdentityOutputStream.lambda$testClose$0((OutputStream)out, tmp));
        Assertions.assertThrows(IOException.class, () -> TestIdentityOutputStream.lambda$testClose$1((OutputStream)out));
    }

    @Test
    void testBasicWrite() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        try (IdentityOutputStream out = new IdentityOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream);){
            out.write(new byte[]{97, 98}, 0, 2);
            out.write(99);
            out.flush();
            byte[] input = outputStream.toByteArray();
            Assertions.assertNotNull((Object)input);
            byte[] expected = new byte[]{97, 98, 99};
            Assertions.assertEquals((int)expected.length, (int)input.length);
            for (int i = 0; i < expected.length; ++i) {
                Assertions.assertEquals((byte)expected[i], (byte)input[i]);
            }
        }
    }

    @Test
    void testClosedCondition() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        IdentityOutputStream out = new IdentityOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream);
        out.close();
        out.close();
        byte[] tmp = new byte[2];
        Assertions.assertThrows(StreamClosedException.class, () -> TestIdentityOutputStream.lambda$testClosedCondition$2((OutputStream)out, tmp));
        Assertions.assertThrows(StreamClosedException.class, () -> TestIdentityOutputStream.lambda$testClosedCondition$3((OutputStream)out));
    }

    private static /* synthetic */ void lambda$testClosedCondition$3(OutputStream out) throws Throwable {
        out.write(97);
    }

    private static /* synthetic */ void lambda$testClosedCondition$2(OutputStream out, byte[] tmp) throws Throwable {
        out.write(tmp, 0, tmp.length);
    }

    private static /* synthetic */ void lambda$testClose$1(OutputStream out) throws Throwable {
        out.write(1);
    }

    private static /* synthetic */ void lambda$testClose$0(OutputStream out, byte[] tmp) throws Throwable {
        out.write(tmp);
    }
}

