/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.shell;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.FileLoggingEventListener;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.IHopLoggingEventListener;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.StreamLogger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="SHELL", name="i18n::ActionShell.Name", description="i18n::ActionShell.Description", image="shell.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", keywords={"i18n::ActionShell.keyword"}, documentationUrl="/workflow/actions/shell.html")
public class ActionShell
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionShell.class;
    private String filename;
    private String workDirectory;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean setLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public LogLevel logFileLevel;
    public boolean execPerRow;
    public boolean setAppendLogfile;
    public boolean insertScript;
    public String script;

    public ActionShell(String name) {
        super(name, "");
    }

    public ActionShell() {
        this("");
        this.clear();
    }

    public void allocate(int nrFields) {
        this.arguments = new String[nrFields];
    }

    public Object clone() {
        ActionShell je = (ActionShell)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            je.allocate(nrFields);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"work_directory", (String)this.workDirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XmlHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"insertScript", (boolean)this.insertScript));
        retval.append("      ").append(XmlHandler.addTagValue((String)"script", (String)this.script));
        retval.append("      ").append(XmlHandler.addTagValue((String)"loglevel", this.logFileLevel == null ? null : this.logFileLevel.getCode()));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("      ").append(XmlHandler.addTagValue((String)("argument" + i), (String)this.arguments[i]));
            }
        }
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.setFilename(XmlHandler.getTagValue((Node)entrynode, (String)"filename"));
            this.setWorkDirectory(XmlHandler.getTagValue((Node)entrynode, (String)"work_directory"));
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.setLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.setAppendLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XmlHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XmlHandler.getTagValue((Node)entrynode, (String)"logext");
            this.logFileLevel = LogLevel.getLogLevelForCode((String)XmlHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.insertScript = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"insertScript"));
            this.script = XmlHandler.getTagValue((Node)entrynode, (String)"script");
            int argnr = 0;
            while (XmlHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.allocate(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XmlHandler.getTagValue((Node)entrynode, (String)("argument" + a));
            }
        }
        catch (HopException e) {
            throw new HopXmlException("Unable to load action of type 'shell' from XML node", (Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.filename = null;
        this.workDirectory = null;
        this.arguments = null;
        this.argFromPrevious = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.execPerRow = false;
        this.setAppendLogfile = false;
        this.insertScript = false;
        this.script = null;
    }

    public void setFilename(String n) {
        this.filename = n;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    public void setWorkDirectory(String n) {
        this.workDirectory = n;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public void setScript(String scriptin) {
        this.script = scriptin;
    }

    public String getScript() {
        return this.script;
    }

    public String getLogFilename() {
        Object retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = (String)retval + (this.logfile == null ? "" : this.logfile);
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = (String)retval + "." + this.logext;
            }
        }
        return retval;
    }

    public Result execute(Result result, int nr) throws HopException {
        FileLoggingEventListener loggingEventListener = null;
        LogLevel shellLogLevel = this.parentWorkflow.getLogLevel();
        if (this.setLogfile) {
            String realLogFilename = this.resolve(this.getLogFilename());
            if (Utils.isEmpty((CharSequence)realLogFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionShell.Exception.LogFilenameMissing", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            try {
                loggingEventListener = new FileLoggingEventListener(this.getLogChannelId(), realLogFilename, this.setAppendLogfile);
                HopLogStore.getAppender().addLoggingEventListener((IHopLoggingEventListener)loggingEventListener);
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionShell.Error.UnableopenAppenderFile", (String[])new String[]{this.getLogFilename(), e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            shellLogLevel = this.logFileLevel;
        }
        this.log.setLogLevel(shellLogLevel);
        result.setEntryNr((long)nr);
        String[] substArgs = null;
        if (this.arguments != null) {
            substArgs = new String[this.arguments.length];
            for (int idx = 0; idx < this.arguments.length; ++idx) {
                substArgs[idx] = this.resolve(this.arguments[idx]);
            }
        }
        int iteration = 0;
        String[] args = substArgs;
        RowMetaAndData resultRow = null;
        boolean first = true;
        ArrayList<RowMetaAndData> rows = result.getRows();
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionShell.Log.FoundPreviousRows", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
        }
        while (first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L) {
            int i;
            first = false;
            resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
            ArrayList<RowMetaAndData> cmdRows = null;
            if (this.execPerRow) {
                if (this.argFromPrevious) {
                    if (resultRow != null) {
                        args = new String[resultRow.size()];
                        for (i = 0; i < resultRow.size(); ++i) {
                            args[i] = resultRow.getString(i, null);
                        }
                    }
                } else {
                    ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                    newList.add(resultRow);
                    cmdRows = newList;
                }
            } else if (this.argFromPrevious) {
                args = null;
                if (resultRow != null) {
                    args = new String[resultRow.size()];
                    for (i = 0; i < resultRow.size(); ++i) {
                        args[i] = resultRow.getString(i, null);
                    }
                } else {
                    cmdRows = rows;
                }
            } else {
                cmdRows = rows;
            }
            this.executeShell(result, (List<RowMetaAndData>)cmdRows, args);
            ++iteration;
        }
        if (this.setLogfile && loggingEventListener != null) {
            HopLogStore.getAppender().removeLoggingEventListener((IHopLoggingEventListener)loggingEventListener);
            loggingEventListener.close();
            ResultFile resultFile = new ResultFile(1, loggingEventListener.getFile(), this.parentWorkflow.getWorkflowName(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeShell(Result result, List<RowMetaAndData> cmdRows, String[] args) {
        fileObject = null;
        realScript = null;
        tempFile = null;
        try {
            block53: {
                block55: {
                    block56: {
                        block54: {
                            base = null;
                            cmds = new ArrayList<String>();
                            if (this.log.isBasic()) {
                                this.logBasic(BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.RunningOn", (String[])new String[]{Const.getSystemOs()}));
                            }
                            if (this.insertScript) {
                                realScript = this.resolve(this.script);
                            } else {
                                realFilename = this.resolve(this.getFilename());
                                fileObject = HopVfs.getFileObject((String)realFilename);
                            }
                            if (Const.getSystemOs().equals("Windows 95")) {
                                base = new String[]{"command.com", "/C"};
                                if (this.insertScript) {
                                    tempFile = HopVfs.createTempFile((String)"hop", (String)"shell.bat", (String)System.getProperty("java.io.tmpdir"));
                                    fileObject = this.createTemporaryShellFile((FileObject)tempFile, realScript);
                                }
                            } else if (Const.getSystemOs().startsWith("Windows")) {
                                base = new String[]{"cmd.exe", "/C"};
                                if (this.insertScript) {
                                    tempFile = HopVfs.createTempFile((String)"hop", (String)"shell.bat", (String)System.getProperty("java.io.tmpdir"));
                                    fileObject = this.createTemporaryShellFile((FileObject)tempFile, realScript);
                                }
                            } else {
                                if (this.insertScript) {
                                    tempFile = HopVfs.createTempFile((String)"hop", (String)"shell", (String)System.getProperty("java.io.tmpdir"));
                                    fileObject = this.createTemporaryShellFile((FileObject)tempFile, realScript);
                                }
                                base = new String[]{HopVfs.getFilename((FileObject)fileObject)};
                            }
                            if (!this.argFromPrevious || cmdRows == null) break block54;
                            for (i = 0; i < base.length; ++i) {
                                cmds.add(base[i]);
                            }
                            if (!Const.getSystemOs().equals("Windows 95") && !Const.getSystemOs().startsWith("Windows")) break block55;
                            cmdline = new StringBuilder(300);
                            cmdline.append('\"');
                            cmdline.append(Const.optionallyQuoteStringByOS((String)HopVfs.getFilename((FileObject)fileObject)));
                            break block56;
                        }
                        if (args != null) {
                            for (i = 0; i < base.length; ++i) {
                                cmds.add(base[i]);
                            }
                            if (Const.getSystemOs().equals("Windows 95") || Const.getSystemOs().startsWith("Windows")) {
                                cmdline = new StringBuilder(300);
                                cmdline.append('\"');
                                cmdline.append(Const.optionallyQuoteStringByOS((String)HopVfs.getFilename((FileObject)fileObject)));
                                for (i = 0; i < args.length; ++i) {
                                    cmdline.append(' ');
                                    cmdline.append(Const.optionallyQuoteStringByOS((String)args[i]));
                                }
                                cmdline.append('\"');
                                cmds.add(cmdline.toString());
                                break block53;
                            } else {
                                for (i = 0; i < args.length; ++i) {
                                    cmds.add(args[i]);
                                }
                            }
                        }
                        break block53;
                    }
                    for (i = 0; i < cmdRows.size(); ++i) {
                        r = cmdRows.get(i);
                        for (j = 0; j < r.size(); ++j) {
                            cmdline.append(' ');
                            cmdline.append(Const.optionallyQuoteStringByOS((String)r.getString(j, null)));
                        }
                    }
                    cmdline.append('\"');
                    cmds.add(cmdline.toString());
                    break block53;
                }
                for (i = 0; i < cmdRows.size(); ++i) {
                    r = cmdRows.get(i);
                    for (j = 0; j < r.size(); ++j) {
                        cmds.add(Const.optionallyQuoteStringByOS((String)r.getString(j, null)));
                    }
                }
            }
            command = new StringBuilder();
            it = cmds.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    command.append(' ');
                } else {
                    first = false;
                }
                command.append((String)it.next());
            }
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.ExecCommand", (String[])new String[]{command.toString()}));
            }
            procBuilder = new ProcessBuilder(cmds);
            env = procBuilder.environment();
            variables = this.getVariableNames();
            for (i = 0; i < variables.length; ++i) {
                if (!StringUtils.isNotEmpty((String)variables[i])) continue;
                env.put(variables[i], Const.NVL((String)this.getVariable(variables[i]), (String)""));
            }
            if (this.getWorkDirectory() != null && !Utils.isEmpty((CharSequence)Const.rtrim((String)this.getWorkDirectory()))) {
                vfsFilename = this.resolve(this.getWorkDirectory());
                file = new File(HopVfs.getFilename((FileObject)HopVfs.getFileObject((String)vfsFilename)));
                procBuilder.directory(file);
            }
            proc = procBuilder.start();
            errorLogger = new StreamLogger(this.log, proc.getErrorStream(), "(stderr)", Boolean.valueOf(true));
            outputLogger = new StreamLogger(this.log, proc.getInputStream(), "(stdout)");
            errorLoggerThread = new Thread((Runnable)errorLogger);
            errorLoggerThread.start();
            outputLoggerThread = new Thread((Runnable)outputLogger);
            outputLoggerThread.start();
            proc.waitFor();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.CommandFinished", (String[])new String[]{command.toString()}));
            }
            result.setExitStatus(proc.exitValue());
            if (result.getExitStatus() != 0) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.ExitStatus", (String[])new String[]{this.resolve(this.getFilename()), "" + result.getExitStatus()}));
                }
                result.setNrErrors(1L);
            }
            errorLoggerThread.join();
            outputLoggerThread.join();
            proc.getErrorStream().close();
            proc.getOutputStream().close();
            ** if (tempFile == null) goto lbl-1000
        }
        catch (IOException ioe) {
            this.logError(BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.ErrorRunningShell", (String[])new String[]{this.resolve(this.getFilename()), ioe.toString()}), ioe);
            result.setNrErrors(1L);
            ** if (tempFile == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                try {
                    tempFile.delete();
                }
                catch (Exception e) {
                    BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.UnexpectedError", (String[])new String[]{tempFile.toString(), e.toString()});
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            catch (InterruptedException ie) {
                this.logError(BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.Shellinterupted", (String[])new String[]{this.resolve(this.getFilename()), ie.toString()}), ie);
                result.setNrErrors(1L);
                ** if (tempFile == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        tempFile.delete();
                    }
                    catch (Exception e) {
                        BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.UnexpectedError", (String[])new String[]{tempFile.toString(), e.toString()});
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
                catch (Exception e) {
                    try {
                        this.logError(BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.UnexpectedError", (String[])new String[]{this.resolve(this.getFilename()), e.toString()}), e);
                        result.setNrErrors(1L);
                        ** if (tempFile == null) goto lbl-1000
                    }
                    catch (Throwable var20_40) {
                        if (tempFile == null) throw var20_40;
                        try {
                            tempFile.delete();
                            throw var20_40;
                        }
                        catch (Exception e) {
                            BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.UnexpectedError", (String[])new String[]{tempFile.toString(), e.toString()});
                        }
                        throw var20_40;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            tempFile.delete();
                        }
                        catch (Exception e) {
                            BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.UnexpectedError", (String[])new String[]{tempFile.toString(), e.toString()});
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                tempFile.delete();
            }
            catch (Exception e) {
                BaseMessages.getString(ActionShell.PKG, (String)"ActionShell.UnexpectedError", (String[])new String[]{tempFile.toString(), e.toString()});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
            return;
        }
        result.setResult(true);
    }

    private FileObject createTemporaryShellFile(FileObject tempFile, String fileContent) throws Exception {
        if (tempFile != null && fileContent != null) {
            try {
                boolean isWindows = Const.isWindows();
                if (!isWindows) {
                    fileContent = this.replaceWinEOL(fileContent);
                }
                tempFile.createFile();
                OutputStream outputStream = tempFile.getContent().getOutputStream();
                outputStream.write(fileContent.getBytes());
                outputStream.close();
                if (!isWindows) {
                    String tempFilename = HopVfs.getFilename((FileObject)tempFile);
                    ProcessBuilder procBuilder = new ProcessBuilder("chmod", "+x", tempFilename);
                    Process proc = procBuilder.start();
                    StreamLogger errorLogger = new StreamLogger(this.log, proc.getErrorStream(), this.toString() + " (stderr)");
                    StreamLogger outputLogger = new StreamLogger(this.log, proc.getInputStream(), this.toString() + " (stdout)");
                    new Thread((Runnable)errorLogger).start();
                    new Thread((Runnable)outputLogger).start();
                    proc.waitFor();
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to create temporary file to execute script", e);
            }
        }
        return tempFile;
    }

    @VisibleForTesting
    String replaceWinEOL(String input) {
        String result = input;
        result = result.replaceAll("\\r\\n?", "\n");
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = this.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "workDirectory", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        if (this.setLogfile) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "logfile", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
    }

    protected String getLogfile() {
        return this.logfile;
    }
}

