/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.keys;

import java.security.AccessController;
import java.security.Provider;
import java.security.Security;

public class Ed25519Provider
extends Provider {
    public static final String KEY_ALGORITHM = "Ed25519";
    private static final Object sInitLock = new Object();
    private static boolean sInitialized = false;

    public Ed25519Provider() {
        super("ConnectBot Ed25519 Provider", 1.0, "Not for use elsewhere");
        AccessController.doPrivileged(() -> {
            this.setup();
            return null;
        });
    }

    protected void setup() {
        this.put("KeyFactory.Ed25519", this.getClass().getPackage().getName() + ".Ed25519KeyFactory");
        this.put("KeyPairGenerator.Ed25519", this.getClass().getPackage().getName() + ".Ed25519KeyPairGenerator");
        this.put("Alg.Alias.KeyFactory.1.3.101.112", KEY_ALGORITHM);
        this.put("Alg.Alias.KeyFactory.EdDSA", KEY_ALGORITHM);
        this.put("Alg.Alias.KeyFactory.OID.1.3.101.112", KEY_ALGORITHM);
        this.put("Alg.Alias.KeyPairGenerator.1.3.101.112", KEY_ALGORITHM);
        this.put("Alg.Alias.KeyPairGenerator.EdDSA", KEY_ALGORITHM);
        this.put("Alg.Alias.KeyPairGenerator.OID.1.3.101.112", KEY_ALGORITHM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertIfNeeded() {
        Object object = sInitLock;
        synchronized (object) {
            if (!sInitialized) {
                Security.addProvider(new Ed25519Provider());
                sInitialized = true;
            }
        }
    }
}

