/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream {
    private BlockCipher currentCipher;
    private final BufferedInputStream bi;
    private byte[] buffer;
    private byte[] enc;
    private int blockSize;
    private int pos;

    public CipherInputStream(BlockCipher tc, InputStream bi) {
        this.bi = bi instanceof BufferedInputStream ? (BufferedInputStream)bi : new BufferedInputStream(bi);
        this.changeCipher(tc);
    }

    public void changeCipher(BlockCipher bc) {
        this.currentCipher = bc;
        this.blockSize = bc.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.enc = new byte[this.blockSize];
        this.pos = this.blockSize;
    }

    private void getBlock() throws IOException {
        int len;
        for (int n = 0; n < this.blockSize; n += len) {
            len = this.bi.read(this.enc, n, this.blockSize - n);
            if (len >= 0) continue;
            throw new IOException("Cannot read full block, EOF reached.");
        }
        try {
            this.currentCipher.transformBlock(this.enc, 0, this.buffer, 0);
        }
        catch (Exception e) {
            throw new IOException("Error while decrypting block.");
        }
        this.pos = 0;
    }

    public int read(byte[] dst) throws IOException {
        return this.read(dst, 0, dst.length);
    }

    public int read(byte[] dst, int off, int len) throws IOException {
        int count = 0;
        while (len > 0) {
            if (this.pos >= this.blockSize) {
                this.getBlock();
            }
            int avail = this.blockSize - this.pos;
            int copy = Math.min(avail, len);
            System.arraycopy(this.buffer, this.pos, dst, off, copy);
            this.pos += copy;
            off += copy;
            len -= copy;
            count += copy;
        }
        return count;
    }

    public int read() throws IOException {
        if (this.pos >= this.blockSize) {
            this.getBlock();
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int readPlain(byte[] b, int off, int len) throws IOException {
        int n;
        int cnt;
        if (this.pos != this.blockSize) {
            throw new IOException("Cannot read plain since crypto buffer is not aligned.");
        }
        for (n = 0; n < len; n += cnt) {
            cnt = this.bi.read(b, off + n, len - n);
            if (cnt >= 0) continue;
            throw new IOException("Cannot fill buffer, EOF reached.");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peekPlain(byte[] b, int off, int len) throws IOException {
        int n;
        if (this.pos != this.blockSize) {
            throw new IOException("Cannot read plain since crypto buffer is not aligned.");
        }
        this.bi.mark(len);
        try {
            int cnt;
            for (n = 0; n < len; n += cnt) {
                cnt = this.bi.read(b, off + n, len - n);
                if (cnt >= 0) continue;
                throw new IOException("Cannot fill buffer, EOF reached.");
            }
        }
        finally {
            this.bi.reset();
        }
        return n;
    }
}

