/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMemory
extends LinkedList<SegmentMemory>
implements LinkedListNode<SegmentMemory> {
    protected static final Logger log = LoggerFactory.getLogger(SegmentMemory.class);
    protected static final boolean IS_LOG_TRACE_ENABLED = log.isTraceEnabled();
    private LeftTupleNode rootNode;
    private LeftTupleNode tipNode;
    private LinkedList<Memory> nodeMemories;
    private long linkedNodeMask;
    private long dirtyNodeMask;
    private long allLinkedMaskTest;
    private List<PathMemory> pathMemories;
    private long segmentPosMaskBit;
    private int pos = -1;
    private TupleSets<LeftTuple> stagedLeftTuples;
    private boolean active;
    private SegmentMemory previous;
    private SegmentMemory next;
    private transient List<PathMemory> dataDrivenPathMemories;
    private transient List<SegmentMemory> peersWithDataDrivenPathMemories;

    public SegmentMemory() {
    }

    public SegmentMemory(LeftTupleNode rootNode) {
        this.rootNode = rootNode;
        this.linkedNodeMask = 0L;
        this.dirtyNodeMask = 0L;
        this.pathMemories = new ArrayList<PathMemory>(1);
        this.nodeMemories = new LinkedList();
        this.stagedLeftTuples = new TupleSetsImpl<LeftTuple>();
    }

    public LeftTupleNode getRootNode() {
        return this.rootNode;
    }

    public LeftTupleNode getTipNode() {
        return this.tipNode;
    }

    public void setTipNode(LeftTupleNode tipNode) {
        this.tipNode = tipNode;
    }

    public LeftTupleSink getSinkFactory() {
        return (LeftTupleSink)this.rootNode;
    }

    public <T extends Memory> T createNodeMemory(MemoryFactory<T> memoryFactory, InternalWorkingMemory wm) {
        T memory = wm.getNodeMemory(memoryFactory);
        this.nodeMemories.add((Memory)memory);
        return memory;
    }

    public LinkedList<Memory> getNodeMemories() {
        return this.nodeMemories;
    }

    public long getLinkedNodeMask() {
        return this.linkedNodeMask;
    }

    public void setLinkedNodeMask(long linkedNodeMask) {
        this.linkedNodeMask = linkedNodeMask;
    }

    public long getDirtyNodeMask() {
        return this.dirtyNodeMask;
    }

    public void updateDirtyNodeMask(long mask) {
        this.dirtyNodeMask |= mask;
    }

    public void updateCleanNodeMask(long mask) {
        this.dirtyNodeMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public String getRuleNames() {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.pathMemories.size(); ++i) {
            if (i > 0) {
                sbuilder.append(", ");
            }
            sbuilder.append(this.pathMemories.get(i));
        }
        return sbuilder.toString();
    }

    public boolean linkNode(long mask, InternalWorkingMemory wm) {
        this.linkedNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("LinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        return this.notifyRuleLinkSegment(wm);
    }

    public boolean linkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("LinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        return this.linkSegmentWithoutRuleNotify();
    }

    public boolean linkSegmentWithoutRuleNotify(long mask) {
        this.dirtyNodeMask |= mask;
        return this.linkSegmentWithoutRuleNotify();
    }

    private boolean linkSegmentWithoutRuleNotify() {
        boolean dataDrivePmemLinked = false;
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                pmem.linkSegmentWithoutRuleNotify(this.segmentPosMaskBit);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
            }
        }
        return dataDrivePmemLinked;
    }

    public boolean notifyRuleLinkSegment(InternalWorkingMemory wm, long mask) {
        this.dirtyNodeMask |= mask;
        return this.notifyRuleLinkSegment(wm);
    }

    public boolean notifyRuleLinkSegment(InternalWorkingMemory wm) {
        boolean dataDrivePmemLinked = false;
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                this.notifyRuleLinkSegment(wm, pmem);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
            }
        }
        return dataDrivePmemLinked;
    }

    public void notifyRuleLinkSegment(InternalWorkingMemory wm, PathMemory pmem) {
        pmem.linkSegment(this.segmentPosMaskBit, wm);
    }

    public boolean unlinkNode(long mask, InternalWorkingMemory wm) {
        boolean dataDrivePmemLinked = false;
        boolean linked = this.isSegmentLinked();
        this.linkedNodeMask ^= mask;
        this.dirtyNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("UnlinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        if (linked && !this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
                pmem.unlinkedSegment(this.segmentPosMaskBit, wm);
            }
        } else {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                if (!this.pathMemories.get(i).isRuleLinked()) continue;
                this.pathMemories.get(i).doLinkRule(wm);
            }
        }
        return dataDrivePmemLinked;
    }

    public void unlinkSegment(InternalWorkingMemory wm) {
        int length = this.pathMemories.size();
        for (int i = 0; i < length; ++i) {
            this.pathMemories.get(i).unlinkedSegment(this.segmentPosMaskBit, wm);
        }
    }

    public void unlinkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask ^= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("UnlinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public boolean isSegmentLinked() {
        return (this.linkedNodeMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public List<PathMemory> getPathMemories() {
        return this.pathMemories;
    }

    public void addPathMemory(PathMemory pathMemory) {
        this.pathMemories.add(pathMemory);
        if (this.isSegmentLinked()) {
            pathMemory.linkSegmentWithoutRuleNotify(this.segmentPosMaskBit);
        }
        if (pathMemory.isDataDriven()) {
            if (this.dataDrivenPathMemories == null) {
                this.dataDrivenPathMemories = new ArrayList<PathMemory>();
            }
            this.dataDrivenPathMemories.add(pathMemory);
        }
    }

    public void mergePathMemories(SegmentMemory segmentMemory) {
        for (PathMemory pmem : segmentMemory.getPathMemories()) {
            if (!this.isAssociatedWith(pmem)) continue;
            this.addPathMemory(pmem);
        }
    }

    private boolean isAssociatedWith(PathMemory pmem) {
        if (pmem instanceof RiaPathMemory) {
            for (RuleImpl rule : ((RiaPathMemory)pmem).getAssociatedRules()) {
                if (!this.rootNode.isAssociatedWith((Rule)rule)) continue;
                return true;
            }
            return false;
        }
        return this.rootNode.isAssociatedWith((Rule)pmem.getRule());
    }

    public void removePathMemory(PathMemory pathMemory) {
        this.pathMemories.remove(pathMemory);
        if (pathMemory.isDataDriven()) {
            this.dataDrivenPathMemories.remove(pathMemory);
            if (this.dataDrivenPathMemories.isEmpty()) {
                this.dataDrivenPathMemories = null;
            }
        }
    }

    public PathMemory getFirstDataDrivenPathMemory() {
        return this.dataDrivenPathMemories == null ? null : this.dataDrivenPathMemories.get(0);
    }

    public boolean hasDataDrivenPathMemories() {
        return this.dataDrivenPathMemories != null;
    }

    public List<PathMemory> getDataDrivenPathMemories() {
        return this.dataDrivenPathMemories;
    }

    public long getSegmentPosMaskBit() {
        return this.segmentPosMaskBit;
    }

    public void setSegmentPosMaskBit(long nodeSegmenMask) {
        this.segmentPosMaskBit = nodeSegmenMask;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean evaluating) {
        this.active = evaluating;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public TupleSets<LeftTuple> getStagedLeftTuples() {
        return this.stagedLeftTuples;
    }

    @Override
    public void add(SegmentMemory segmentMemory) {
        super.add(segmentMemory);
        if (segmentMemory.hasDataDrivenPathMemories()) {
            if (this.peersWithDataDrivenPathMemories == null) {
                this.peersWithDataDrivenPathMemories = new ArrayList<SegmentMemory>();
            }
            this.peersWithDataDrivenPathMemories.add(segmentMemory);
        }
    }

    @Override
    public void remove(SegmentMemory segmentMemory) {
        super.remove(segmentMemory);
        if (this.peersWithDataDrivenPathMemories != null) {
            this.peersWithDataDrivenPathMemories.remove(segmentMemory);
            if (this.peersWithDataDrivenPathMemories.isEmpty()) {
                this.peersWithDataDrivenPathMemories = null;
            }
        }
    }

    public Iterator<SegmentMemory> getPeersWithDataDrivenPathMemoriesIterator() {
        return this.peersWithDataDrivenPathMemories == null ? Collections.emptyIterator() : this.peersWithDataDrivenPathMemories.iterator();
    }

    @Override
    public SegmentMemory getNext() {
        return this.next;
    }

    @Override
    public void setNext(SegmentMemory next) {
        this.next = next;
    }

    @Override
    public SegmentMemory getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(SegmentMemory previous) {
        this.previous = previous;
    }

    @Override
    public void nullPrevNext() {
        this.previous = null;
        this.next = null;
    }

    @Override
    public int hashCode() {
        return this.rootNode.getId();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SegmentMemory && this.rootNode.getId() == ((SegmentMemory)obj).rootNode.getId();
    }

    public Prototype asPrototype() {
        return new Prototype(this);
    }

    public List<NetworkNode> getNodesInSegment() {
        java.util.LinkedList<NetworkNode> nodes = new java.util.LinkedList<NetworkNode>();
        LeftTupleNode currentNode = this.tipNode;
        while (currentNode != this.rootNode) {
            nodes.add(0, currentNode);
            currentNode = ((LeftTupleSinkNode)currentNode).getLeftTupleSource();
        }
        nodes.add(0, currentNode);
        return nodes;
    }

    public void reset(Prototype prototype) {
        this.dirtyNodeMask = 0L;
        this.linkedNodeMask = prototype != null ? prototype.linkedNodeMask : 0L;
        this.stagedLeftTuples.resetAll();
    }

    public String toString() {
        return "Segment from " + this.rootNode + " to " + this.tipNode;
    }

    public static class AccumulateMemoryPrototype
    extends MemoryPrototype {
        private final BetaMemoryPrototype betaProto;

        private AccumulateMemoryPrototype(AccumulateNode.AccumulateMemory accMemory) {
            this.betaProto = new BetaMemoryPrototype(accMemory.getBetaMemory());
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory accMemory) {
            this.betaProto.populateMemory(wm, ((AccumulateNode.AccumulateMemory)accMemory).getBetaMemory());
        }
    }

    public static class TimerMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        private TimerMemoryPrototype(TimerNode.TimerNodeMemory timerMemory) {
            this.nodePosMaskBit = timerMemory.getNodePosMaskBit();
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory mem) {
            TimerNode.TimerNodeMemory tmem = (TimerNode.TimerNodeMemory)mem;
            tmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class QueryMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;
        private final QueryElementNode queryNode;

        private QueryMemoryPrototype(QueryElementNode.QueryElementNodeMemory queryMemory) {
            this.nodePosMaskBit = queryMemory.getNodePosMaskBit();
            this.queryNode = queryMemory.getNode();
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory mem) {
            QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)mem;
            SegmentMemory querySmem = SegmentUtilities.getQuerySegmentMemory(wm, (LeftTupleSource)qmem.getSegmentMemory().getRootNode(), this.queryNode);
            qmem.setQuerySegmentMemory(querySmem);
            qmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class ReactiveFromMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        private ReactiveFromMemoryPrototype(ReactiveFromNode.ReactiveFromMemory memory) {
            this.nodePosMaskBit = memory.getBetaMemory().getNodePosMaskBit();
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory memory) {
            ((ReactiveFromNode.ReactiveFromMemory)memory).setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class LiaMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        private LiaMemoryPrototype(LeftInputAdapterNode.LiaNodeMemory liaMemory) {
            this.nodePosMaskBit = liaMemory.getNodePosMaskBit();
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory liaMemory) {
            ((SegmentNodeMemory)liaMemory).setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class BetaMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;
        private RightInputAdapterNode riaNode;

        private BetaMemoryPrototype(BetaMemory betaMemory) {
            this.nodePosMaskBit = betaMemory.getNodePosMaskBit();
            if (betaMemory.getRiaRuleMemory() != null) {
                this.riaNode = betaMemory.getRiaRuleMemory().getRightInputAdapterNode();
            }
        }

        @Override
        public void populateMemory(InternalWorkingMemory wm, Memory memory) {
            BetaMemory betaMemory = (BetaMemory)memory;
            betaMemory.setNodePosMaskBit(this.nodePosMaskBit);
            if (this.riaNode != null) {
                RightInputAdapterNode.RiaNodeMemory riaMem = wm.getNodeMemory(this.riaNode);
                betaMemory.setRiaRuleMemory(riaMem.getRiaPathMemory());
            }
        }
    }

    public static abstract class MemoryPrototype {
        public static MemoryPrototype get(Memory memory) {
            if (memory instanceof BetaMemory) {
                return new BetaMemoryPrototype((BetaMemory)memory);
            }
            if (memory instanceof LeftInputAdapterNode.LiaNodeMemory) {
                return new LiaMemoryPrototype((LeftInputAdapterNode.LiaNodeMemory)memory);
            }
            if (memory instanceof QueryElementNode.QueryElementNodeMemory) {
                return new QueryMemoryPrototype((QueryElementNode.QueryElementNodeMemory)memory);
            }
            if (memory instanceof TimerNode.TimerNodeMemory) {
                return new TimerMemoryPrototype((TimerNode.TimerNodeMemory)memory);
            }
            if (memory instanceof AccumulateNode.AccumulateMemory) {
                return new AccumulateMemoryPrototype((AccumulateNode.AccumulateMemory)memory);
            }
            if (memory instanceof ReactiveFromNode.ReactiveFromMemory) {
                return new ReactiveFromMemoryPrototype((ReactiveFromNode.ReactiveFromMemory)memory);
            }
            return null;
        }

        public abstract void populateMemory(InternalWorkingMemory var1, Memory var2);
    }

    public static class Prototype {
        private final LeftTupleNode rootNode;
        private final LeftTupleNode tipNode;
        private final long linkedNodeMask;
        private final long allLinkedMaskTest;
        private final long segmentPosMaskBit;
        private final int pos;
        private final List<MemoryPrototype> memories = new ArrayList<MemoryPrototype>();
        private List<NetworkNode> nodesInSegment;

        private Prototype(SegmentMemory smem) {
            this.rootNode = smem.rootNode;
            this.tipNode = smem.tipNode;
            this.linkedNodeMask = smem.linkedNodeMask;
            this.allLinkedMaskTest = smem.allLinkedMaskTest;
            this.segmentPosMaskBit = smem.segmentPosMaskBit;
            this.pos = smem.pos;
            for (Memory mem = (Memory)smem.nodeMemories.getFirst(); mem != null; mem = (Memory)mem.getNext()) {
                this.memories.add(MemoryPrototype.get(mem));
            }
        }

        public SegmentMemory newSegmentMemory(InternalWorkingMemory wm) {
            SegmentMemory smem = new SegmentMemory(this.rootNode);
            smem.tipNode = this.tipNode;
            smem.linkedNodeMask = this.linkedNodeMask;
            smem.allLinkedMaskTest = this.allLinkedMaskTest;
            smem.segmentPosMaskBit = this.segmentPosMaskBit;
            smem.pos = this.pos;
            int i = 0;
            for (NetworkNode node : this.getNodesInSegment(smem)) {
                MemoryPrototype proto;
                Object mem = wm.getNodeMemory((MemoryFactory)((Object)node));
                mem.setSegmentMemory(smem);
                smem.getNodeMemories().add((Memory)mem);
                if ((proto = this.memories.get(i++)) == null) continue;
                proto.populateMemory(wm, (Memory)mem);
            }
            return smem;
        }

        private List<NetworkNode> getNodesInSegment(SegmentMemory smem) {
            if (this.nodesInSegment == null) {
                this.nodesInSegment = smem.getNodesInSegment();
            }
            return this.nodesInSegment;
        }
    }
}

