/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.BaseTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.index.TupleList;

public class BaseLeftTuple
extends BaseTuple
implements LeftTuple {
    private static final long serialVersionUID = 540L;
    private int index;
    private LeftTuple parent;
    private LeftTuple leftParent;
    private RightTuple rightParent;
    private LeftTuple rightParentPrevious;
    private LeftTuple rightParentNext;
    private LeftTuple firstChild;
    private LeftTuple lastChild;
    protected TupleList memory;
    private LeftTuple peer;
    private short stagedTypeForQueries;

    public BaseLeftTuple() {
    }

    public BaseLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        this.setFactHandle(factHandle);
        this.sink = sink;
        if (leftTupleMemoryEnabled) {
            factHandle.addTupleInPosition(this);
        }
    }

    public BaseLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        this.setFactHandle(factHandle);
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
        this.sink = sink;
    }

    public BaseLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
        this.setPropagationContext(pctx);
        if (leftTupleMemoryEnabled) {
            if (leftTuple.getLastChild() != null) {
                this.handlePrevious = leftTuple.getLastChild();
                this.handlePrevious.setHandleNext(this);
            } else {
                leftTuple.setFirstChild(this);
            }
            leftTuple.setLastChild(this);
        }
        this.sink = sink;
    }

    public BaseLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
        this.rightParent = rightTuple;
        this.setFactHandle(rightTuple.getFactHandle());
        this.setPropagationContext(rightTuple.getPropagationContext());
        if (leftTuple.getLastChild() != null) {
            this.handlePrevious = leftTuple.getLastChild();
            this.handlePrevious.setHandleNext(this);
        } else {
            leftTuple.setFirstChild(this);
        }
        leftTuple.setLastChild(this);
        if (rightTuple.getLastChild() != null) {
            this.rightParentPrevious = rightTuple.getLastChild();
            this.rightParentPrevious.setRightParentNext(this);
        } else {
            rightTuple.setFirstChild(this);
        }
        rightTuple.setLastChild(this);
        this.sink = sink;
    }

    public BaseLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink, boolean leftTupleMemoryEnabled) {
        this(leftTuple, rightTuple, null, null, sink, leftTupleMemoryEnabled);
    }

    public BaseLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        this.setFactHandle(rightTuple.getFactHandle());
        this.index = leftTuple.getIndex() + 1;
        this.parent = leftTuple.getNextParentWithHandle();
        this.leftParent = leftTuple;
        this.rightParent = rightTuple;
        this.setPropagationContext(rightTuple.getPropagationContext());
        if (leftTupleMemoryEnabled) {
            if (currentLeftChild == null) {
                if (leftTuple.getLastChild() != null) {
                    this.handlePrevious = leftTuple.getLastChild();
                    this.handlePrevious.setHandleNext(this);
                } else {
                    leftTuple.setFirstChild(this);
                }
                leftTuple.setLastChild(this);
            } else {
                this.handleNext = currentLeftChild;
                this.handlePrevious = currentLeftChild.getHandlePrevious();
                currentLeftChild.setHandlePrevious(this);
                if (this.handlePrevious == null) {
                    this.leftParent.setFirstChild(this);
                } else {
                    this.handlePrevious.setHandleNext(this);
                }
            }
            if (currentRightChild == null) {
                if (rightTuple.getLastChild() != null) {
                    this.rightParentPrevious = rightTuple.getLastChild();
                    this.rightParentPrevious.setRightParentNext(this);
                } else {
                    rightTuple.setFirstChild(this);
                }
                rightTuple.setLastChild(this);
            } else {
                this.rightParentNext = currentRightChild;
                this.rightParentPrevious = currentRightChild.getRightParentPrevious();
                currentRightChild.setRightParentPrevious(this);
                if (this.rightParentPrevious == null) {
                    this.rightParent.setFirstChild(this);
                } else {
                    this.rightParentPrevious.setRightParentNext(this);
                }
            }
        }
        this.sink = sink;
    }

    @Override
    public LeftTuple getNextParentWithHandle() {
        return this.handle != null ? this : (this.parent != null ? this.parent.getNextParentWithHandle() : this);
    }

    @Override
    public void reAdd() {
        this.getFactHandle().addLastLeftTuple(this);
    }

    @Override
    public void reAddLeft() {
        if (this.handleNext != null) {
            if (this.handlePrevious != null) {
                this.handlePrevious.setHandleNext(this.handleNext);
                this.handleNext.setHandlePrevious(this.handlePrevious);
            } else {
                if (this.leftParent.getFirstChild() == this) {
                    this.leftParent.setFirstChild(this.getHandleNext());
                }
                this.handleNext.setHandlePrevious(null);
            }
            this.handlePrevious = this.leftParent.getLastChild();
            this.handlePrevious.setHandleNext(this);
            this.leftParent.setLastChild(this);
            this.handleNext = null;
        }
    }

    @Override
    public void reAddRight() {
        if (this.rightParentNext != null) {
            if (this.rightParentPrevious != null) {
                this.rightParentPrevious.setRightParentNext(this.rightParentNext);
                this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
            } else {
                if (this.rightParent.getFirstChild() == this) {
                    this.rightParent.setFirstChild(this.rightParentNext);
                }
                this.rightParentNext.setRightParentPrevious(null);
            }
            this.rightParentPrevious = this.rightParent.getLastChild();
            this.rightParentPrevious.setRightParentNext(this);
            this.rightParent.setLastChild(this);
            this.rightParentNext = null;
        }
    }

    @Override
    public void unlinkFromLeftParent() {
        LeftTuple previousParent = this.getHandlePrevious();
        LeftTuple nextParent = this.getHandleNext();
        if (previousParent != null && nextParent != null) {
            this.handlePrevious.setHandleNext(nextParent);
            this.handleNext.setHandlePrevious(previousParent);
        } else if (nextParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setFirstChild(nextParent);
            } else {
                this.getFactHandle().removeLeftTuple(this);
            }
            nextParent.setHandlePrevious(null);
        } else if (previousParent != null) {
            if (this.leftParent != null) {
                this.leftParent.setLastChild(previousParent);
            } else {
                this.getFactHandle().removeLeftTuple(this);
            }
            previousParent.setHandleNext(null);
        } else if (this.leftParent != null) {
            this.leftParent.setFirstChild(null);
            this.leftParent.setLastChild(null);
        } else {
            this.getFactHandle().removeLeftTuple(this);
        }
        this.handlePrevious = null;
        this.handleNext = null;
    }

    @Override
    public void unlinkFromRightParent() {
        if (this.rightParent == null) {
            return;
        }
        LeftTuple previousParent = this.rightParentPrevious;
        LeftTuple nextParent = this.rightParentNext;
        if (previousParent != null && nextParent != null) {
            this.rightParentPrevious.setRightParentNext(this.rightParentNext);
            this.rightParentNext.setRightParentPrevious(this.rightParentPrevious);
        } else if (nextParent != null) {
            this.rightParent.setFirstChild(nextParent);
            nextParent.setRightParentPrevious(null);
        } else if (previousParent != null) {
            this.rightParent.setLastChild(previousParent);
            previousParent.setRightParentNext(null);
        } else {
            this.rightParent.setFirstChild(null);
            this.rightParent.setLastChild(null);
        }
        this.rightParentPrevious = null;
        this.rightParentNext = null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public LeftTupleSink getTupleSink() {
        return (LeftTupleSink)this.sink;
    }

    @Override
    public void setLeftTupleSink(LeftTupleSink sink) {
        this.sink = sink;
    }

    @Override
    public LeftTuple getLeftParent() {
        return this.leftParent;
    }

    @Override
    public void setLeftParent(LeftTuple leftParent) {
        this.leftParent = leftParent;
    }

    @Override
    public LeftTuple getHandlePrevious() {
        return (LeftTuple)this.handlePrevious;
    }

    @Override
    public LeftTuple getHandleNext() {
        return (LeftTuple)this.handleNext;
    }

    @Override
    public RightTuple getRightParent() {
        return this.rightParent;
    }

    @Override
    public void setRightParent(RightTuple rightParent) {
        this.rightParent = rightParent;
    }

    @Override
    public LeftTuple getRightParentPrevious() {
        return this.rightParentPrevious;
    }

    @Override
    public void setRightParentPrevious(LeftTuple rightParentLeft) {
        this.rightParentPrevious = rightParentLeft;
    }

    @Override
    public LeftTuple getRightParentNext() {
        return this.rightParentNext;
    }

    @Override
    public void setRightParentNext(LeftTuple rightParentRight) {
        this.rightParentNext = rightParentRight;
    }

    @Override
    public InternalFactHandle get(int index) {
        LeftTuple entry = this;
        while (entry.getIndex() != index) {
            entry = entry.getParent();
        }
        return entry.getFactHandle();
    }

    @Override
    public InternalFactHandle[] toFactHandles() {
        InternalFactHandle[] handles = new InternalFactHandle[((LeftTupleSinkNode)this.sink).getLeftTupleSource().getObjectCount()];
        LeftTuple entry = (LeftTuple)this.skipEmptyHandles();
        for (int i = handles.length - 1; i >= 0; --i) {
            handles[i] = entry.getFactHandle();
            entry = entry.getParent();
        }
        return handles;
    }

    @Override
    public Object[] toObjects(boolean reverse) {
        Object[] objs = new Object[((LeftTupleSinkNode)this.sink).getLeftTupleSource().getObjectCount()];
        LeftTuple entry = (LeftTuple)this.skipEmptyHandles();
        if (!reverse) {
            for (int i = objs.length - 1; i >= 0; --i) {
                objs[i] = entry.getFactHandle().getObject();
                entry = entry.getParent();
            }
        } else {
            for (int i = 0; i < objs.length; ++i) {
                objs[i] = entry.getFactHandle().getObject();
                entry = entry.getParent();
            }
        }
        return objs;
    }

    @Override
    public void clearBlocker() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlocker(RightTuple blocker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RightTuple getBlocker() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeftTuple getBlockedPrevious() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlockedPrevious(LeftTuple blockerPrevious) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeftTuple getBlockedNext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlockedNext(LeftTuple blockerNext) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            buffer.append(entry.getFactHandle());
            if (entry.getParent() == null) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.getFactHandle() == null ? 0 : this.getFactHandle().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LeftTuple)) {
            return false;
        }
        LeftTuple other = (LeftTuple)object;
        if (this.hashCode() != other.hashCode() || this.getFactHandle() != other.getFactHandle()) {
            return false;
        }
        if (this.parent == null) {
            return other.getParent() == null;
        }
        return this.parent.equals(other.getParent());
    }

    @Override
    public int size() {
        return this.index + 1;
    }

    @Override
    public LeftTuple getFirstChild() {
        return this.firstChild;
    }

    @Override
    public void setFirstChild(LeftTuple firstChild) {
        this.firstChild = firstChild;
    }

    @Override
    public LeftTuple getLastChild() {
        return this.lastChild;
    }

    @Override
    public void setLastChild(LeftTuple lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public TupleList getMemory() {
        return this.memory;
    }

    @Override
    public void setMemory(TupleList memory) {
        this.memory = memory;
    }

    public LeftTuple getStagedNext() {
        return (LeftTuple)this.stagedNext;
    }

    @Override
    public LeftTuple getStagedPrevious() {
        return (LeftTuple)this.stagedPrevious;
    }

    @Override
    public void clearStaged() {
        super.clearStaged();
        if (this.getContextObject() == Boolean.TRUE) {
            this.setContextObject(null);
        }
    }

    @Override
    public LeftTuple getPeer() {
        return this.peer;
    }

    @Override
    public void setPeer(LeftTuple peer) {
        this.peer = peer;
    }

    @Override
    public LeftTuple getSubTuple(int elements) {
        LeftTuple entry = this;
        if (elements <= this.size()) {
            int lastindex = elements - 1;
            while (entry.getIndex() != lastindex) {
                entry = entry.getParent();
            }
        }
        return entry;
    }

    @Override
    public LeftTuple getParent() {
        return this.parent;
    }

    protected String toExternalString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%08X", System.identityHashCode(this))).append(":");
        long[] ids = new long[this.index + 1];
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            ids[entry.getIndex()] = entry.getFactHandle().getId();
        }
        builder.append(Arrays.toString(ids)).append(" sink=").append(this.sink.getClass().getSimpleName()).append("(").append(this.sink.getId()).append(")");
        return builder.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.memory = null;
    }

    public void initPeer(BaseLeftTuple original, LeftTupleSink sink) {
        this.index = original.index;
        this.parent = original.parent;
        this.leftParent = original.leftParent;
        this.setFactHandle(original.getFactHandle());
        this.setPropagationContext(original.getPropagationContext());
        this.sink = sink;
    }

    @Override
    public Object getObject(int index) {
        return this.get(index).getObject();
    }

    @Override
    public ObjectTypeNode.Id getInputOtnId() {
        return this.sink != null ? this.getTupleSink().getLeftInputOtnId() : null;
    }

    public LeftTupleSource getTupleSource() {
        return this.sink != null ? this.getTupleSink().getLeftTupleSource() : null;
    }

    @Override
    public short getStagedTypeForQueries() {
        return this.stagedTypeForQueries;
    }

    @Override
    public void setStagedTypeForQueries(short stagedTypeForQueries) {
        this.stagedTypeForQueries = stagedTypeForQueries;
    }

    @Override
    public boolean isStagedOnRight() {
        return false;
    }
}

