/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.core.common.FactHandleClassStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ObjectStore;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;

public class IdentityObjectStore
implements Externalizable,
ObjectStore {
    private Map<Object, InternalFactHandle> fhMap = new IdentityHashMap<Object, InternalFactHandle>();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fhMap);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fhMap = (Map)in.readObject();
    }

    @Override
    public int size() {
        return this.fhMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fhMap.isEmpty();
    }

    @Override
    public void clear() {
        this.fhMap.clear();
    }

    @Override
    public Object getObjectForHandle(InternalFactHandle handle) {
        InternalFactHandle reconnectedHandle = this.reconnect(handle);
        return reconnectedHandle != null ? reconnectedHandle.getObject() : null;
    }

    @Override
    public InternalFactHandle reconnect(InternalFactHandle handle) {
        InternalFactHandle reconnectedHandle = this.fhMap.values().stream().filter(fh -> fh.getId() == handle.getId()).findFirst().orElse(null);
        return reconnectedHandle != null && handle.getIdentityHashCode() == reconnectedHandle.getIdentityHashCode() ? reconnectedHandle : null;
    }

    @Override
    public InternalFactHandle getHandleForObject(Object object) {
        return this.fhMap.get(object);
    }

    @Override
    public InternalFactHandle getHandleForObjectIdentity(Object object) {
        return this.fhMap.get(object);
    }

    @Override
    public void updateHandle(InternalFactHandle handle, Object object) {
        this.removeHandle(handle);
        handle.setObject(object);
        this.addHandle(handle, object);
    }

    @Override
    public void addHandle(InternalFactHandle handle, Object object) {
        this.fhMap.put(object, handle);
    }

    @Override
    public void removeHandle(InternalFactHandle handle) {
        this.fhMap.remove(handle.getObject());
    }

    @Override
    public Iterator<Object> iterateObjects() {
        return this.fhMap.keySet().iterator();
    }

    @Override
    public Iterator<Object> iterateObjects(ObjectFilter filter) {
        return this.fhMap.keySet().stream().filter(arg_0 -> ((ObjectFilter)filter).accept(arg_0)).iterator();
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles() {
        return this.fhMap.values().iterator();
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles(ObjectFilter filter) {
        return this.fhMap.values().stream().filter(fh -> filter.accept(fh.getObject())).iterator();
    }

    @Override
    public Iterator<Object> iterateNegObjects(ObjectFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<InternalFactHandle> iterateNegFactHandles(ObjectFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FactHandleClassStore getStoreForClass(Class<?> clazz) {
        return new IdentityFactHandleClassStore(clazz);
    }

    @Override
    public boolean clearClassStore(Class<?> clazz) {
        ClassObjectFilter filter = new ClassObjectFilter(clazz);
        List<Object> toBeRemoved = this.fhMap.keySet().stream().filter(arg_0 -> ((ObjectFilter)filter).accept(arg_0)).collect(Collectors.toList());
        toBeRemoved.forEach(this.fhMap::remove);
        return !toBeRemoved.isEmpty();
    }

    public class IdentityFactHandleClassStore
    implements FactHandleClassStore {
        private final Class<?> clazz;

        public IdentityFactHandleClassStore(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Iterator<InternalFactHandle> iterator() {
            ClassObjectFilter filter = new ClassObjectFilter(this.clazz);
            return IdentityObjectStore.this.fhMap.values().stream().filter(arg_0 -> IdentityFactHandleClassStore.lambda$iterator$0((ObjectFilter)filter, arg_0)).collect(Collectors.toList()).iterator();
        }

        private static /* synthetic */ boolean lambda$iterator$0(ObjectFilter filter, InternalFactHandle fh) {
            return filter.accept(fh.getObject());
        }
    }
}

