/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.listen;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AzureListenerDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = AzureListenerMeta.class;
    private Text wTransformName;
    private TextVar wNamespace;
    private TextVar wEventHub;
    private TextVar wSasKeyName;
    private TextVar wSasKey;
    private TextVar wBatchSize;
    private TextVar wPrefetchSize;
    private TextVar wOutputField;
    private TextVar wPartitionIdField;
    private TextVar wOffsetField;
    private TextVar wSequenceNumberField;
    private TextVar wHostField;
    private TextVar wEnqueuedTimeField;
    private TextVar wConsumerGroup;
    private TextVar wStorageConnectionString;
    private TextVar wStorageContainerName;
    private TextVar wBatchPipeline;
    private TextVar wBatchInput;
    private TextVar wBatchOutput;
    private TextVar wMaxWaitTime;
    private AzureListenerMeta input;

    public AzureListenerDialog(Shell parent, IVariables variables, Object inputMetadata, PipelineMeta transMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)inputMetadata, transMeta, transformName);
        this.input = (AzureListenerMeta)((Object)inputMetadata);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("Azure Event Hubs Listener");
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText("Transform name");
        PropsUi.setLook((Widget)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlNamespace = new Label((Composite)this.shell, 131072);
        wlNamespace.setText("Event Hubs namespace");
        PropsUi.setLook((Widget)wlNamespace);
        FormData fdlNamespace = new FormData();
        fdlNamespace.left = new FormAttachment(0, 0);
        fdlNamespace.right = new FormAttachment(middle, -margin);
        fdlNamespace.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlNamespace.setLayoutData((Object)fdlNamespace);
        this.wNamespace = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wNamespace);
        this.wNamespace.addModifyListener(lsMod);
        FormData fdNamespace = new FormData();
        fdNamespace.left = new FormAttachment(middle, 0);
        fdNamespace.right = new FormAttachment(100, 0);
        fdNamespace.top = new FormAttachment((Control)wlNamespace, 0, 0x1000000);
        this.wNamespace.setLayoutData((Object)fdNamespace);
        lastControl = this.wNamespace;
        Label wlEventHub = new Label((Composite)this.shell, 131072);
        wlEventHub.setText("Event Hubs Instance name");
        PropsUi.setLook((Widget)wlEventHub);
        FormData fdlEventHub = new FormData();
        fdlEventHub.left = new FormAttachment(0, 0);
        fdlEventHub.right = new FormAttachment(middle, -margin);
        fdlEventHub.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlEventHub.setLayoutData((Object)fdlEventHub);
        this.wEventHub = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEventHub);
        this.wEventHub.addModifyListener(lsMod);
        FormData fdEventHub = new FormData();
        fdEventHub.left = new FormAttachment(middle, 0);
        fdEventHub.right = new FormAttachment(100, 0);
        fdEventHub.top = new FormAttachment((Control)wlEventHub, 0, 0x1000000);
        this.wEventHub.setLayoutData((Object)fdEventHub);
        lastControl = this.wEventHub;
        Label wlSasKeyName = new Label((Composite)this.shell, 131072);
        wlSasKeyName.setText("SAS Policy key name");
        PropsUi.setLook((Widget)wlSasKeyName);
        FormData fdlSasKeyName = new FormData();
        fdlSasKeyName.left = new FormAttachment(0, 0);
        fdlSasKeyName.right = new FormAttachment(middle, -margin);
        fdlSasKeyName.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSasKeyName.setLayoutData((Object)fdlSasKeyName);
        this.wSasKeyName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSasKeyName);
        this.wSasKeyName.addModifyListener(lsMod);
        FormData fdSasKeyName = new FormData();
        fdSasKeyName.left = new FormAttachment(middle, 0);
        fdSasKeyName.right = new FormAttachment(100, 0);
        fdSasKeyName.top = new FormAttachment((Control)wlSasKeyName, 0, 0x1000000);
        this.wSasKeyName.setLayoutData((Object)fdSasKeyName);
        lastControl = this.wSasKeyName;
        Label wlSasKey = new Label((Composite)this.shell, 131072);
        wlSasKey.setText("SAS Key value");
        PropsUi.setLook((Widget)wlSasKey);
        FormData fdlSasKey = new FormData();
        fdlSasKey.left = new FormAttachment(0, 0);
        fdlSasKey.right = new FormAttachment(middle, -margin);
        fdlSasKey.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSasKey.setLayoutData((Object)fdlSasKey);
        this.wSasKey = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wSasKey.setEchoChar('*');
        PropsUi.setLook((Widget)this.wSasKey);
        this.wSasKey.addModifyListener(lsMod);
        FormData fdSasKey = new FormData();
        fdSasKey.left = new FormAttachment(middle, 0);
        fdSasKey.right = new FormAttachment(100, 0);
        fdSasKey.top = new FormAttachment((Control)wlSasKey, 0, 0x1000000);
        this.wSasKey.setLayoutData((Object)fdSasKey);
        lastControl = this.wSasKey;
        Label wlConsumerGroup = new Label((Composite)this.shell, 131072);
        wlConsumerGroup.setText("Consumer Group Name");
        PropsUi.setLook((Widget)wlConsumerGroup);
        FormData fdlConsumerGroup = new FormData();
        fdlConsumerGroup.left = new FormAttachment(0, 0);
        fdlConsumerGroup.right = new FormAttachment(middle, -margin);
        fdlConsumerGroup.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlConsumerGroup.setLayoutData((Object)fdlConsumerGroup);
        this.wConsumerGroup = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wConsumerGroup);
        this.wConsumerGroup.addModifyListener(lsMod);
        FormData fdConsumerGroup = new FormData();
        fdConsumerGroup.left = new FormAttachment(middle, 0);
        fdConsumerGroup.right = new FormAttachment(100, 0);
        fdConsumerGroup.top = new FormAttachment((Control)wlConsumerGroup, 0, 0x1000000);
        this.wConsumerGroup.setLayoutData((Object)fdConsumerGroup);
        lastControl = this.wConsumerGroup;
        Label wlStorageContainerName = new Label((Composite)this.shell, 131072);
        wlStorageContainerName.setText("Storage Container name");
        PropsUi.setLook((Widget)wlStorageContainerName);
        FormData fdlStorageContainerName = new FormData();
        fdlStorageContainerName.left = new FormAttachment(0, 0);
        fdlStorageContainerName.right = new FormAttachment(middle, -margin);
        fdlStorageContainerName.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlStorageContainerName.setLayoutData((Object)fdlStorageContainerName);
        this.wStorageContainerName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wStorageContainerName);
        this.wStorageContainerName.addModifyListener(lsMod);
        FormData fdStorageContainerName = new FormData();
        fdStorageContainerName.left = new FormAttachment(middle, 0);
        fdStorageContainerName.right = new FormAttachment(100, 0);
        fdStorageContainerName.top = new FormAttachment((Control)wlStorageContainerName, 0, 0x1000000);
        this.wStorageContainerName.setLayoutData((Object)fdStorageContainerName);
        lastControl = this.wStorageContainerName;
        Label wlStorageConnectionString = new Label((Composite)this.shell, 131072);
        wlStorageConnectionString.setText("Storage Connection String");
        PropsUi.setLook((Widget)wlStorageConnectionString);
        FormData fdlStorageConnectionString = new FormData();
        fdlStorageConnectionString.left = new FormAttachment(0, 0);
        fdlStorageConnectionString.right = new FormAttachment(middle, -margin);
        fdlStorageConnectionString.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlStorageConnectionString.setLayoutData((Object)fdlStorageConnectionString);
        this.wStorageConnectionString = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wStorageConnectionString.setEchoChar('*');
        PropsUi.setLook((Widget)this.wStorageConnectionString);
        this.wStorageConnectionString.addModifyListener(lsMod);
        FormData fdStorageConnectionString = new FormData();
        fdStorageConnectionString.left = new FormAttachment(middle, 0);
        fdStorageConnectionString.right = new FormAttachment(100, 0);
        fdStorageConnectionString.top = new FormAttachment((Control)wlStorageConnectionString, 0, 0x1000000);
        this.wStorageConnectionString.setLayoutData((Object)fdStorageConnectionString);
        lastControl = this.wStorageConnectionString;
        Label wlBatchSize = new Label((Composite)this.shell, 131072);
        wlBatchSize.setText("Batch size");
        PropsUi.setLook((Widget)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        fdlBatchSize.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        lastControl = this.wBatchSize;
        Label wlPrefetchSize = new Label((Composite)this.shell, 131072);
        wlPrefetchSize.setText("Prefetch size");
        PropsUi.setLook((Widget)wlPrefetchSize);
        FormData fdlPrefetchSize = new FormData();
        fdlPrefetchSize.left = new FormAttachment(0, 0);
        fdlPrefetchSize.right = new FormAttachment(middle, -margin);
        fdlPrefetchSize.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlPrefetchSize.setLayoutData((Object)fdlPrefetchSize);
        this.wPrefetchSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPrefetchSize);
        this.wPrefetchSize.addModifyListener(lsMod);
        FormData fdPrefetchSize = new FormData();
        fdPrefetchSize.left = new FormAttachment(middle, 0);
        fdPrefetchSize.right = new FormAttachment(100, 0);
        fdPrefetchSize.top = new FormAttachment((Control)wlPrefetchSize, 0, 0x1000000);
        this.wPrefetchSize.setLayoutData((Object)fdPrefetchSize);
        lastControl = this.wPrefetchSize;
        Label wlOutputField = new Label((Composite)this.shell, 131072);
        wlOutputField.setText("Message (data) output field name");
        PropsUi.setLook((Widget)wlOutputField);
        FormData fdlOutputField = new FormData();
        fdlOutputField.left = new FormAttachment(0, 0);
        fdlOutputField.right = new FormAttachment(middle, -margin);
        fdlOutputField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlOutputField.setLayoutData((Object)fdlOutputField);
        this.wOutputField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wOutputField);
        this.wOutputField.addModifyListener(lsMod);
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(middle, 0);
        fdOutputField.right = new FormAttachment(100, 0);
        fdOutputField.top = new FormAttachment((Control)wlOutputField, 0, 0x1000000);
        this.wOutputField.setLayoutData((Object)fdOutputField);
        lastControl = this.wOutputField;
        Label wlPartitionIdField = new Label((Composite)this.shell, 131072);
        wlPartitionIdField.setText("Partition ID field name");
        PropsUi.setLook((Widget)wlPartitionIdField);
        FormData fdlPartitionIdField = new FormData();
        fdlPartitionIdField.left = new FormAttachment(0, 0);
        fdlPartitionIdField.right = new FormAttachment(middle, -margin);
        fdlPartitionIdField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlPartitionIdField.setLayoutData((Object)fdlPartitionIdField);
        this.wPartitionIdField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPartitionIdField);
        this.wPartitionIdField.addModifyListener(lsMod);
        FormData fdPartitionIdField = new FormData();
        fdPartitionIdField.left = new FormAttachment(middle, 0);
        fdPartitionIdField.right = new FormAttachment(100, 0);
        fdPartitionIdField.top = new FormAttachment((Control)wlPartitionIdField, 0, 0x1000000);
        this.wPartitionIdField.setLayoutData((Object)fdPartitionIdField);
        lastControl = this.wPartitionIdField;
        Label wlOffsetField = new Label((Composite)this.shell, 131072);
        wlOffsetField.setText("Offset field name");
        PropsUi.setLook((Widget)wlOffsetField);
        FormData fdlOffsetField = new FormData();
        fdlOffsetField.left = new FormAttachment(0, 0);
        fdlOffsetField.right = new FormAttachment(middle, -margin);
        fdlOffsetField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlOffsetField.setLayoutData((Object)fdlOffsetField);
        this.wOffsetField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wOffsetField);
        this.wOffsetField.addModifyListener(lsMod);
        FormData fdOffsetField = new FormData();
        fdOffsetField.left = new FormAttachment(middle, 0);
        fdOffsetField.right = new FormAttachment(100, 0);
        fdOffsetField.top = new FormAttachment((Control)wlOffsetField, 0, 0x1000000);
        this.wOffsetField.setLayoutData((Object)fdOffsetField);
        lastControl = this.wOffsetField;
        Label wlSequenceNumberField = new Label((Composite)this.shell, 131072);
        wlSequenceNumberField.setText("Sequence number field name");
        PropsUi.setLook((Widget)wlSequenceNumberField);
        FormData fdlSequenceNumberField = new FormData();
        fdlSequenceNumberField.left = new FormAttachment(0, 0);
        fdlSequenceNumberField.right = new FormAttachment(middle, -margin);
        fdlSequenceNumberField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSequenceNumberField.setLayoutData((Object)fdlSequenceNumberField);
        this.wSequenceNumberField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSequenceNumberField);
        this.wSequenceNumberField.addModifyListener(lsMod);
        FormData fdSequenceNumberField = new FormData();
        fdSequenceNumberField.left = new FormAttachment(middle, 0);
        fdSequenceNumberField.right = new FormAttachment(100, 0);
        fdSequenceNumberField.top = new FormAttachment((Control)wlSequenceNumberField, 0, 0x1000000);
        this.wSequenceNumberField.setLayoutData((Object)fdSequenceNumberField);
        lastControl = this.wSequenceNumberField;
        Label wlHostField = new Label((Composite)this.shell, 131072);
        wlHostField.setText("Host (owner) field name");
        PropsUi.setLook((Widget)wlHostField);
        FormData fdlHostField = new FormData();
        fdlHostField.left = new FormAttachment(0, 0);
        fdlHostField.right = new FormAttachment(middle, -margin);
        fdlHostField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlHostField.setLayoutData((Object)fdlHostField);
        this.wHostField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wHostField);
        this.wHostField.addModifyListener(lsMod);
        FormData fdHostField = new FormData();
        fdHostField.left = new FormAttachment(middle, 0);
        fdHostField.right = new FormAttachment(100, 0);
        fdHostField.top = new FormAttachment((Control)wlHostField, 0, 0x1000000);
        this.wHostField.setLayoutData((Object)fdHostField);
        lastControl = this.wHostField;
        Label wlEnqueuedTimeField = new Label((Composite)this.shell, 131072);
        wlEnqueuedTimeField.setText("Enqueued time field name");
        PropsUi.setLook((Widget)wlEnqueuedTimeField);
        FormData fdlEnqueuedTimeField = new FormData();
        fdlEnqueuedTimeField.left = new FormAttachment(0, 0);
        fdlEnqueuedTimeField.right = new FormAttachment(middle, -margin);
        fdlEnqueuedTimeField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlEnqueuedTimeField.setLayoutData((Object)fdlEnqueuedTimeField);
        this.wEnqueuedTimeField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEnqueuedTimeField);
        this.wEnqueuedTimeField.addModifyListener(lsMod);
        FormData fdEnqueuedTimeField = new FormData();
        fdEnqueuedTimeField.left = new FormAttachment(middle, 0);
        fdEnqueuedTimeField.right = new FormAttachment(100, 0);
        fdEnqueuedTimeField.top = new FormAttachment((Control)wlEnqueuedTimeField, 0, 0x1000000);
        this.wEnqueuedTimeField.setLayoutData((Object)fdEnqueuedTimeField);
        lastControl = this.wEnqueuedTimeField;
        Label wlSeparator1 = new Label((Composite)this.shell, 258);
        PropsUi.setLook((Widget)wlSeparator1);
        FormData fdlSeparator1 = new FormData();
        fdlSeparator1.left = new FormAttachment(0, margin);
        fdlSeparator1.right = new FormAttachment(100, -margin);
        fdlSeparator1.top = new FormAttachment((Control)lastControl, 4 * margin);
        wlSeparator1.setLayoutData((Object)fdlSeparator1);
        lastControl = wlSeparator1;
        Label wlBatchPipeline = new Label((Composite)this.shell, 131072);
        wlBatchPipeline.setText("Batch pipeline");
        PropsUi.setLook((Widget)wlBatchPipeline);
        FormData fdlBatchPipeline = new FormData();
        fdlBatchPipeline.left = new FormAttachment(0, 0);
        fdlBatchPipeline.right = new FormAttachment(middle, -margin);
        fdlBatchPipeline.top = new FormAttachment((Control)lastControl, 4 * margin);
        wlBatchPipeline.setLayoutData((Object)fdlBatchPipeline);
        Button wbBatchPipeline = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbBatchPipeline);
        wbBatchPipeline.setText(BaseMessages.getString((String)"System.Button.Browse"));
        wbBatchPipeline.addListener(13, e -> this.browseForPipeline());
        FormData fdbBatchPipeline = new FormData();
        fdbBatchPipeline.right = new FormAttachment(100, -margin);
        fdbBatchPipeline.top = new FormAttachment((Control)wlBatchPipeline, 0, 0x1000000);
        wbBatchPipeline.setLayoutData((Object)fdbBatchPipeline);
        this.wBatchPipeline = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBatchPipeline);
        this.wBatchPipeline.addModifyListener(lsMod);
        FormData fdBatchPipeline = new FormData();
        fdBatchPipeline.left = new FormAttachment(middle, 0);
        fdBatchPipeline.right = new FormAttachment((Control)wbBatchPipeline, -margin);
        fdBatchPipeline.top = new FormAttachment((Control)wlBatchPipeline, 0, 0x1000000);
        this.wBatchPipeline.setLayoutData((Object)fdBatchPipeline);
        lastControl = this.wBatchPipeline;
        Label wlBatchInput = new Label((Composite)this.shell, 131072);
        wlBatchInput.setText("Pipeline input transform");
        PropsUi.setLook((Widget)wlBatchInput);
        FormData fdlBatchInput = new FormData();
        fdlBatchInput.left = new FormAttachment(0, 0);
        fdlBatchInput.right = new FormAttachment(middle, -margin);
        fdlBatchInput.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBatchInput.setLayoutData((Object)fdlBatchInput);
        Button wbBatchInput = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbBatchInput);
        wbBatchInput.setText("Select...");
        wbBatchInput.addListener(13, e -> this.selectInputTransform());
        FormData fdbBatchInput = new FormData();
        fdbBatchInput.right = new FormAttachment(100, -margin);
        fdbBatchInput.top = new FormAttachment((Control)wlBatchInput, 0, 0x1000000);
        wbBatchInput.setLayoutData((Object)fdbBatchInput);
        this.wBatchInput = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBatchInput);
        this.wBatchInput.addModifyListener(lsMod);
        FormData fdBatchInput = new FormData();
        fdBatchInput.left = new FormAttachment(middle, 0);
        fdBatchInput.right = new FormAttachment((Control)wbBatchInput, -margin);
        fdBatchInput.top = new FormAttachment((Control)wlBatchInput, 0, 0x1000000);
        this.wBatchInput.setLayoutData((Object)fdBatchInput);
        lastControl = this.wBatchInput;
        Label wlBatchOutput = new Label((Composite)this.shell, 131072);
        wlBatchOutput.setText("Pipeline output transform");
        PropsUi.setLook((Widget)wlBatchOutput);
        FormData fdlBatchOutput = new FormData();
        fdlBatchOutput.left = new FormAttachment(0, 0);
        fdlBatchOutput.right = new FormAttachment(middle, -margin);
        fdlBatchOutput.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBatchOutput.setLayoutData((Object)fdlBatchOutput);
        Button wbBatchOutput = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbBatchOutput);
        wbBatchOutput.setText("Select...");
        wbBatchOutput.addListener(13, e -> this.selectOutputTransform());
        FormData fdbBatchOutput = new FormData();
        fdbBatchOutput.right = new FormAttachment(100, -margin);
        fdbBatchOutput.top = new FormAttachment((Control)wlBatchOutput, 0, 0x1000000);
        wbBatchOutput.setLayoutData((Object)fdbBatchOutput);
        this.wBatchOutput = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBatchOutput);
        this.wBatchOutput.addModifyListener(lsMod);
        FormData fdBatchOutput = new FormData();
        fdBatchOutput.left = new FormAttachment(middle, 0);
        fdBatchOutput.right = new FormAttachment((Control)wbBatchOutput, -margin);
        fdBatchOutput.top = new FormAttachment((Control)wlBatchOutput, 0, 0x1000000);
        this.wBatchOutput.setLayoutData((Object)fdBatchOutput);
        lastControl = this.wBatchOutput;
        Label wlMaxWaitTime = new Label((Composite)this.shell, 131072);
        wlMaxWaitTime.setText("Maximum wait time (ms)");
        PropsUi.setLook((Widget)wlMaxWaitTime);
        FormData fdlMaxWaitTime = new FormData();
        fdlMaxWaitTime.left = new FormAttachment(0, 0);
        fdlMaxWaitTime.right = new FormAttachment(middle, -margin);
        fdlMaxWaitTime.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlMaxWaitTime.setLayoutData((Object)fdlMaxWaitTime);
        this.wMaxWaitTime = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMaxWaitTime);
        this.wMaxWaitTime.addModifyListener(lsMod);
        FormData fdMaxWaitTime = new FormData();
        fdMaxWaitTime.left = new FormAttachment(middle, 0);
        fdMaxWaitTime.right = new FormAttachment(100, 0);
        fdMaxWaitTime.top = new FormAttachment((Control)wlMaxWaitTime, 0, 0x1000000);
        this.wMaxWaitTime.setLayoutData((Object)fdMaxWaitTime);
        lastControl = this.wMaxWaitTime;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void browseForPipeline() {
        HopPipelineFileType type = HopGui.getDataOrchestrationPerspective().getPipelineFileType();
        BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wBatchPipeline, (FileObject)null, (String[])type.getFilterExtensions(), (String[])type.getFilterNames(), (boolean)true);
    }

    private void selectInputTransform() {
        this.selectTransform(this.wBatchInput, "Select the transform to send the messages to:");
    }

    private void selectOutputTransform() {
        this.selectTransform(this.wBatchOutput, "Select a transform to read output from:");
    }

    private void selectTransform(TextVar textVar, String message) {
        try {
            AzureListenerMeta meta = new AzureListenerMeta();
            this.getInfo(meta);
            PipelineMeta pipelineMeta = AzureListenerMeta.loadBatchPipelineMeta(meta, this.metadataProvider, this.variables);
            String[] transformNames = pipelineMeta.getTransformNames();
            EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, transformNames, "Select transform", message);
            String transformName = dialog.open();
            if (transformName != null) {
                textVar.setText(transformName);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error selecting transform", e);
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wNamespace.setText(Const.NVL((String)this.input.getNamespace(), (String)""));
        this.wEventHub.setText(Const.NVL((String)this.input.getEventHubName(), (String)""));
        this.wSasKeyName.setText(Const.NVL((String)this.input.getSasKeyName(), (String)""));
        this.wSasKey.setText(Const.NVL((String)this.input.getSasKey(), (String)""));
        this.wConsumerGroup.setText(Const.NVL((String)this.input.getConsumerGroupName(), (String)""));
        this.wStorageContainerName.setText(Const.NVL((String)this.input.getStorageContainerName(), (String)""));
        this.wStorageConnectionString.setText(Const.NVL((String)this.input.getStorageConnectionString(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wPrefetchSize.setText(Const.NVL((String)this.input.getPrefetchSize(), (String)""));
        this.wOutputField.setText(Const.NVL((String)this.input.getOutputField(), (String)""));
        this.wPartitionIdField.setText(Const.NVL((String)this.input.getPartitionIdField(), (String)""));
        this.wOffsetField.setText(Const.NVL((String)this.input.getOffsetField(), (String)""));
        this.wHostField.setText(Const.NVL((String)this.input.getHostField(), (String)""));
        this.wSequenceNumberField.setText(Const.NVL((String)this.input.getSequenceNumberField(), (String)""));
        this.wEnqueuedTimeField.setText(Const.NVL((String)this.input.getEnqueuedTimeField(), (String)""));
        this.wBatchPipeline.setText(Const.NVL((String)this.input.getBatchPipeline(), (String)""));
        this.wBatchInput.setText(Const.NVL((String)this.input.getBatchInputTransform(), (String)""));
        this.wBatchOutput.setText(Const.NVL((String)this.input.getBatchOutputTransform(), (String)""));
        this.wMaxWaitTime.setText(Const.NVL((String)this.input.getBatchMaxWaitTime(), (String)""));
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(AzureListenerMeta meta) {
        meta.setNamespace(this.wNamespace.getText());
        meta.setEventHubName(this.wEventHub.getText());
        meta.setSasKeyName(this.wSasKeyName.getText());
        meta.setSasKey(this.wSasKey.getText());
        meta.setConsumerGroupName(this.wConsumerGroup.getText());
        meta.setStorageContainerName(this.wStorageContainerName.getText());
        meta.setStorageConnectionString(this.wStorageConnectionString.getText());
        meta.setBatchSize(this.wBatchSize.getText());
        meta.setPrefetchSize(this.wPrefetchSize.getText());
        meta.setOutputField(this.wOutputField.getText());
        meta.setPartitionIdField(this.wPartitionIdField.getText());
        meta.setOffsetField(this.wOffsetField.getText());
        meta.setSequenceNumberField(this.wSequenceNumberField.getText());
        meta.setHostField(this.wHostField.getText());
        meta.setEnqueuedTimeField(this.wEnqueuedTimeField.getText());
        meta.setBatchPipeline(this.wBatchPipeline.getText());
        meta.setBatchInputTransform(this.wBatchInput.getText());
        meta.setBatchOutputTransform(this.wBatchOutput.getText());
        meta.setBatchMaxWaitTime(this.wMaxWaitTime.getText());
    }
}

