/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgbulkloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoaderMappingMeta;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoaderMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PGBulkLoaderDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = PGBulkLoaderMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private CCombo wLoadAction;
    private TableView wReturn;
    private TextVar wEnclosure;
    private TextVar wDelimiter;
    private TextVar wDbNameOverride;
    private Button wStopOnError;
    private final PGBulkLoaderMeta input;
    private ColumnInfo[] ciReturn;
    private final Map<String, Integer> inputFields;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private static final String PASSTROUGH_LABEL = "PGBulkLoaderDialog.PassThrough.Label";
    private static final String DATEMASK_LABEL = "PGBulkLoaderDialog.DateMask.Label";
    private static final String DATETIMEMASK_LABEL = "PGBulkLoaderDialog.DateTimeMask.Label";

    public PGBulkLoaderDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (PGBulkLoaderMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                PGBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getDatabaseMeta(), lsMod);
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlLoadAction = new Label((Composite)this.shell, 131072);
        wlLoadAction.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.LoadAction.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLoadAction);
        FormData fdlLoadAction = new FormData();
        fdlLoadAction.left = new FormAttachment(0, 0);
        fdlLoadAction.right = new FormAttachment(middle, -margin);
        fdlLoadAction.top = new FormAttachment((Control)this.wTable, margin);
        wlLoadAction.setLayoutData((Object)fdlLoadAction);
        this.wLoadAction = new CCombo((Composite)this.shell, 2060);
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.select(0);
        this.wLoadAction.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wLoadAction);
        FormData fdLoadAction = new FormData();
        fdLoadAction.left = new FormAttachment(middle, 0);
        fdLoadAction.top = new FormAttachment((Control)this.wTable, margin);
        fdLoadAction.right = new FormAttachment(100, 0);
        this.wLoadAction.setLayoutData((Object)fdLoadAction);
        fdLoadAction = new FormData();
        fdLoadAction.left = new FormAttachment(middle, 0);
        fdLoadAction.top = new FormAttachment((Control)this.wTable, margin);
        fdLoadAction.right = new FormAttachment(100, 0);
        this.wLoadAction.setLayoutData((Object)fdLoadAction);
        Label wlDbNameOverride = new Label((Composite)this.shell, 131072);
        wlDbNameOverride.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DbNameOverride.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDbNameOverride);
        FormData fdlDbNameOverride = new FormData();
        fdlDbNameOverride.left = new FormAttachment(0, 0);
        fdlDbNameOverride.top = new FormAttachment((Control)this.wLoadAction, margin);
        fdlDbNameOverride.right = new FormAttachment(middle, -margin);
        wlDbNameOverride.setLayoutData((Object)fdlDbNameOverride);
        this.wDbNameOverride = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDbNameOverride);
        this.wDbNameOverride.addModifyListener(lsMod);
        FormData fdDbNameOverride = new FormData();
        fdDbNameOverride.left = new FormAttachment(middle, 0);
        fdDbNameOverride.top = new FormAttachment((Control)this.wLoadAction, margin);
        fdDbNameOverride.right = new FormAttachment(100, 0);
        this.wDbNameOverride.setLayoutData((Object)fdDbNameOverride);
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Enclosure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.top = new FormAttachment((Control)this.wDbNameOverride, margin);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.top = new FormAttachment((Control)this.wDbNameOverride, margin);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        Label wlDelimiter = new Label((Composite)this.shell, 131072);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Delimiter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.left = new FormAttachment(0, 0);
        fdlDelimiter.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdlDelimiter.right = new FormAttachment(middle, -margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        this.wDelimiter = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        FormData fdDelimiter = new FormData();
        fdDelimiter.left = new FormAttachment(middle, 0);
        fdDelimiter.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdDelimiter.right = new FormAttachment(100, 0);
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        Label wlStopOnError = new Label((Composite)this.shell, 131072);
        wlStopOnError.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.StopOnError.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStopOnError);
        FormData fdlStopOnError = new FormData();
        fdlStopOnError.left = new FormAttachment(0, 0);
        fdlStopOnError.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdlStopOnError.right = new FormAttachment(middle, -margin);
        wlStopOnError.setLayoutData((Object)fdlStopOnError);
        this.wStopOnError = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wStopOnError);
        FormData fdStopOnError = new FormData();
        fdStopOnError.left = new FormAttachment(middle, 0);
        fdStopOnError.top = new FormAttachment((Control)wlStopOnError, 0, 0x1000000);
        fdStopOnError.right = new FormAttachment(100, 0);
        this.wStopOnError.setLayoutData((Object)fdStopOnError);
        this.wStopOnError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PGBulkLoaderDialog.this.input.setChanged();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wSql, this.wCancel}, margin, null);
        Label wlReturn = new Label((Composite)this.shell, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)this.wStopOnError, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getMappings() != null ? this.input.getMappings().size() : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)DATEMASK_LABEL, (String[])new String[0]), 2, new String[]{"", BaseMessages.getString(PKG, (String)PASSTROUGH_LABEL, (String[])new String[0]), BaseMessages.getString(PKG, (String)DATEMASK_LABEL, (String[])new String[0]), BaseMessages.getString(PKG, (String)DATETIMEMASK_LABEL, (String[])new String[0])}, true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        Button wGetLU = new Button((Composite)this.shell, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wlReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetLU.setLayoutData((Object)fdGetLU);
        Button wDoMapping = new Button((Composite)this.shell, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wGetLU, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)wDoMapping, -margin);
        fdReturn.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk.addListener(13, e -> this.ok());
        wGetLU.addListener(13, e -> this.getUpdate());
        this.wSql.addListener(13, e -> this.create());
        this.wCancel.addListener(13, e -> this.cancel());
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PGBulkLoaderDialog.this.getTableName();
            }
        });
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        String action;
        this.logDebug(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getMappings() != null) {
            for (int i = 0; i < this.input.getMappings().size(); ++i) {
                String dateMask;
                PGBulkLoaderMappingMeta mapping = this.input.getMappings().get(i);
                TableItem item = this.wReturn.table.getItem(i);
                if (mapping.getFieldTable() != null) {
                    item.setText(1, mapping.getFieldTable());
                }
                if (mapping.getFieldStream() != null) {
                    item.setText(2, mapping.getFieldStream());
                }
                if ((dateMask = mapping.getDateMask()) != null) {
                    if ("PASS THROUGH".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)PASSTROUGH_LABEL, (String[])new String[0]));
                        continue;
                    }
                    if ("DATE".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)DATEMASK_LABEL, (String[])new String[0]));
                        continue;
                    }
                    if ("DATETIME".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)DATETIMEMASK_LABEL, (String[])new String[0]));
                        continue;
                    }
                    item.setText(3, "");
                    continue;
                }
                item.setText(3, "");
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getDelimiter() != null) {
            this.wDelimiter.setText(this.input.getDelimiter());
        }
        if (this.input.getEnclosure() != null) {
            this.wEnclosure.setText(this.input.getEnclosure());
        }
        this.wStopOnError.setSelection(this.input.isStopOnError());
        if (this.input.getDbNameOverride() != null) {
            this.wDbNameOverride.setText(this.input.getDbNameOverride());
        }
        if ("INSERT".equals(action = this.input.getLoadAction())) {
            this.wLoadAction.select(0);
        } else if ("TRUNCATE".equals(action)) {
            this.wLoadAction.select(1);
        } else {
            this.logDebug("Internal error: load_action set to default 'insert'");
            this.wLoadAction.select(0);
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMetaInterface = this.transformMeta.getTransform();
        try {
            targetFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)292);
            boolean bl = goOn = (answer & 0x20) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(PGBulkLoaderMeta inf) {
        int nrFields = this.wReturn.nrNonEmpty();
        inf.getMappings().clear();
        inf.setDbNameOverride(this.wDbNameOverride.getText());
        this.logDebug(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrFields}));
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            PGBulkLoaderMappingMeta mapping = new PGBulkLoaderMappingMeta();
            mapping.setFieldTable(item.getText(1));
            mapping.setFieldStream(item.getText(2));
            if (BaseMessages.getString(PKG, (String)PASSTROUGH_LABEL, (String[])new String[0]).equals(item.getText(3))) {
                mapping.setDateMask("PASS THROUGH");
            } else if (BaseMessages.getString(PKG, (String)DATEMASK_LABEL, (String[])new String[0]).equals(item.getText(3))) {
                mapping.setDateMask("DATE");
            } else if (BaseMessages.getString(PKG, (String)DATETIMEMASK_LABEL, (String[])new String[0]).equals(item.getText(3))) {
                mapping.setDateMask("DATETIME");
            } else {
                mapping.setDateMask("");
            }
            inf.getMappings().add(mapping);
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText()));
        inf.setDelimiter(this.wDelimiter.getText());
        inf.setEnclosure(this.wEnclosure.getText());
        inf.setStopOnError(this.wStopOnError.getSelection());
        String action = this.wLoadAction.getText();
        if (BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("INSERT");
        } else if (BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("TRUNCATE");
        } else {
            this.logDebug("Internal error: load_action set to default 'insert', value found '" + action + "'.");
            inf.setLoadAction("INSERT");
        }
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName);
        if (databaseMeta != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    if (v.getType() == 3) {
                        tableItem.setText(3, BaseMessages.getString(PKG, (String)DATEMASK_LABEL, (String[])new String[0]));
                    } else {
                        tableItem.setText(3, "");
                    }
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            PGBulkLoaderMeta info = new PGBulkLoaderMeta();
            this.getInfo(info);
            String name = this.transformName;
            TransformMeta transformMeta = new TransformMeta(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.TransformMeta.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, info.getDatabaseMeta(), DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta databaseMeta;
                String tableName = this.wTable.getText();
                String connectionName = this.wConnection.getText();
                String schemaName = this.wSchema.getText();
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
                if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName)) != null) {
                    Database db = new Database(loggingObject, this.variables, databaseMeta);
                    try {
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, schemaName, tableName);
                        IRowMeta r = db.getTableFields(schemaTable);
                        if (null != r && null != (fieldNames = r.getFieldNames())) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo colInfo : this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (db != null) {
                                db.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            db = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

