/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

@HopServerServlet(id="stopPipeline", name="Stop a pipeline")
public class StopPipelineServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = StopPipelineServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/stopPipeline";

    public StopPipelineServlet() {
    }

    public StopPipelineServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StopPipelineServlet.StopOfPipelineRequested", (String[])new String[0]));
        }
        String pipelineName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean inputOnly = "Y".equalsIgnoreCase(request.getParameter("inputOnly"));
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        try {
            IPipelineEngine<PipelineMeta> pipeline;
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"StopPipelineServlet.StopPipeline", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/hop/pipelineStatus") + "?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "\">");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            if (Utils.isEmpty((CharSequence)id)) {
                HopServerObjectEntry entry = this.getPipelineMap().getFirstServerObjectEntry(pipelineName);
                if (entry == null) {
                    pipeline = null;
                } else {
                    id = entry.getId();
                    pipeline = this.getPipelineMap().getPipeline(entry);
                }
            } else {
                HopServerObjectEntry entry = new HopServerObjectEntry(pipelineName, id);
                pipeline = this.getPipelineMap().getPipeline(entry);
            }
            if (pipeline != null) {
                pipeline.stopAll();
                String message = BaseMessages.getString(PKG, (String)"StopPipelineServlet.PipelineStopRequested", (String[])new String[]{pipelineName});
                if (useXML) {
                    out.println(new WebResult("OK", message, id).getXml());
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/hop/pipelineStatus") + "?name=" + URLEncoder.encode(pipelineName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToPipelineStatusPage", (String[])new String[0]) + "</a><p>");
                }
            } else {
                String message = BaseMessages.getString(PKG, (String)"StopPipelineServlet.CanNotFindPipeline", (String[])new String[]{pipelineName});
                if (useXML) {
                    out.println(new WebResult("ERROR", message, id).getXml());
                } else {
                    out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                    out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                    response.setStatus(400);
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)).getXml());
            }
            out.println("<p>");
            out.println("<pre>");
            out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
            out.println("</pre>");
            response.setStatus(400);
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Stop pipeline";
    }

    @Override
    public String getService() {
        return "/hop/stopPipeline (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

