/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;

@HopServerServlet(id="registerExecInfo", name="Register execution information")
public class RegisterExecutionInfoServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -2817136625869923847L;
    public static final String CONTEXT_PATH = "/hop/registerExecInfo";
    public static final String TYPE_EXECUTION = "execution";
    public static final String TYPE_STATE = "state";
    public static final String TYPE_DATA = "data";
    public static final String PARAMETER_TYPE = "type";
    public static final String PARAMETER_LOCATION = "location";

    public RegisterExecutionInfoServlet() {
    }

    public RegisterExecutionInfoServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Register execution information");
        }
        String type = request.getParameter(PARAMETER_TYPE);
        String locationName = request.getParameter(PARAMETER_LOCATION);
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        response.setContentType("text/xml");
        out.print(XmlHandler.getXmlHeader());
        response.setStatus(200);
        try {
            if (StringUtils.isEmpty((String)type)) {
                throw new HopException("Please specify the type of execution information to register.");
            }
            if (StringUtils.isEmpty((String)locationName)) {
                throw new HopException("Please specify the name of the execution information location to register at.");
            }
            MultiMetadataProvider provider = this.pipelineMap.getHopServerConfig().getMetadataProvider();
            IHopMetadataSerializer serializer = provider.getSerializer(ExecutionInfoLocation.class);
            ExecutionInfoLocation location = (ExecutionInfoLocation)serializer.load(locationName);
            if (location == null) {
                throw new HopException("Unable to find execution information location " + locationName);
            }
            try {
                int c;
                location.getExecutionInfoLocation().initialize(this.variables, (IHopMetadataProvider)provider);
                StringBuilder json = new StringBuilder(request.getContentLength());
                while ((c = in.read()) != -1) {
                    json.append((char)c);
                }
                switch (type) {
                    case "execution": {
                        Execution execution = (Execution)HopJson.newMapper().readValue(json.toString(), Execution.class);
                        location.getExecutionInfoLocation().registerExecution(execution);
                        break;
                    }
                    case "state": {
                        ExecutionState state = (ExecutionState)HopJson.newMapper().readValue(json.toString(), ExecutionState.class);
                        location.getExecutionInfoLocation().updateExecutionState(state);
                        break;
                    }
                    case "data": {
                        ExecutionData data = (ExecutionData)HopJson.newMapper().readValue(json.toString(), ExecutionData.class);
                        location.getExecutionInfoLocation().registerData(data);
                        break;
                    }
                    default: {
                        throw new HopException("Unknown update type: " + type + " allowed are: execution, state, data");
                    }
                }
                out.println(new WebResult("OK", "Registration successful at location " + locationName));
            }
            finally {
                location.getExecutionInfoLocation().close();
            }
        }
        catch (Exception ex) {
            response.setStatus(500);
            out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
        }
    }

    public String toString() {
        return "Register execution information";
    }

    @Override
    public String getService() {
        return "/hop/registerExecInfo (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

