/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.config;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataObjectFactory;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEnginePluginType;

public class WorkflowRunConfigurationMetadataObjectFactory
implements IHopMetadataObjectFactory {
    public Object createObject(String id, Object parentObject) throws HopException {
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.findPluginWithId(WorkflowEnginePluginType.class, id);
        if (plugin == null) {
            throw new HopException("Unable to find the plugin in the context of a pipeline engine plugin for id: " + id);
        }
        try {
            IWorkflowEngine engine = (IWorkflowEngine)registry.loadClass(plugin, IWorkflowEngine.class);
            IWorkflowEngineRunConfiguration engineRunConfiguration = engine.createDefaultWorkflowEngineRunConfiguration();
            engineRunConfiguration.setEnginePluginId(plugin.getIds()[0]);
            engineRunConfiguration.setEnginePluginName(plugin.getName());
            if (parentObject != null && parentObject instanceof IVariables) {
                engineRunConfiguration.initializeFrom((IVariables)parentObject);
            }
            return engineRunConfiguration;
        }
        catch (HopPluginException e) {
            throw new HopException("Unable to load the workflow engine plugin class with plugin id: " + id, (Throwable)e);
        }
    }

    public String getObjectId(Object object) throws HopException {
        if (!(object instanceof IWorkflowEngineRunConfiguration)) {
            throw new HopException("Object provided needs to be of class " + IWorkflowEngineRunConfiguration.class.getName());
        }
        return ((IWorkflowEngineRunConfiguration)object).getEnginePluginId();
    }
}

