/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.resource;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceXmlPropertyEmitter;
import org.apache.hop.resource.ResourceEntry;

public class ResourceReference {
    private IResourceHolder resourceReferenceHolder;
    private List<ResourceEntry> entries;

    public ResourceReference(IResourceHolder resourceReferenceHolder, List<ResourceEntry> entries) {
        this.resourceReferenceHolder = resourceReferenceHolder;
        this.entries = entries;
    }

    public ResourceReference(IResourceHolder resourceReferenceHolder) {
        this.resourceReferenceHolder = resourceReferenceHolder;
        this.entries = new ArrayList<ResourceEntry>();
    }

    public IResourceHolder getReferenceHolder() {
        return this.resourceReferenceHolder;
    }

    public void setReferenceHolder(IResourceHolder resourceReferenceHolder) {
        this.resourceReferenceHolder = resourceReferenceHolder;
    }

    public List<ResourceEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ResourceEntry> entries) {
        this.entries = entries;
    }

    public String toXml() {
        return this.toXml(null, 0);
    }

    public String toXml(IResourceXmlPropertyEmitter injector) {
        return this.toXml(injector, 0);
    }

    public String toXml(int indentLevel) {
        return this.toXml(null, indentLevel);
    }

    public String toXml(IResourceXmlPropertyEmitter injector, int indentLevel) {
        StringBuilder buff = new StringBuilder();
        this.addXmlElementWithAttribute(buff, indentLevel, "ActionComponent", "type", this.resourceReferenceHolder.getPluginId());
        this.addXmlElement(buff, ++indentLevel, "ComponentName", this.resourceReferenceHolder.getName());
        this.addXmlElement(buff, indentLevel, "ComponentId", this.resourceReferenceHolder.getTypeId());
        this.addXmlElement(buff, indentLevel, "ComponentResources");
        ++indentLevel;
        for (ResourceEntry entry : this.getEntries()) {
            buff.append(entry.toXml(indentLevel));
        }
        this.addXmlCloseElement(buff, --indentLevel, "ComponentResources");
        if (injector != null) {
            this.addXmlElement(buff, indentLevel, "ComponentProperties");
            buff.append(injector.getExtraResourceProperties(this.resourceReferenceHolder, ++indentLevel));
            this.addXmlCloseElement(buff, --indentLevel, "ComponentProperties");
        }
        this.addXmlCloseElement(buff, --indentLevel, "ActionComponent");
        return buff.toString();
    }

    public void addXmlElementWithAttribute(StringBuilder buff, int indentLevel, String elementName, String attrName, String attrValue) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("<").append(elementName).append(" ").append(attrName).append("='");
        buff.append(attrValue).append("'>").append("\r\n");
    }

    public void addXmlCloseElement(StringBuilder buff, int indentLevel, String elementName) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("</").append(elementName).append(">").append("\r\n");
    }

    public void addXmlElement(StringBuilder buff, int indentLevel, String elementName) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("<").append(elementName).append(">").append("\r\n");
    }

    public void addXmlElement(StringBuilder buff, int indentLevel, String elementName, String elementValue) {
        buff.append(StringUtil.getIndent((int)indentLevel)).append("<").append(elementName).append("><![CDATA[").append(elementValue).append("]]></").append(elementName).append(">").append("\r\n");
    }
}

