/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import org.apache.hop.core.Const;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.Metrics;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;

public class TransformInitThread
implements Runnable {
    private static final Class<?> PKG = Pipeline.class;
    public boolean ok;
    public boolean finished;
    public boolean doIt;
    private TransformMetaDataCombi combi;
    private Pipeline pipeline;
    private ILogChannel log;

    public TransformInitThread(TransformMetaDataCombi combi, Pipeline pipeline, ILogChannel log) {
        this.combi = combi;
        this.pipeline = pipeline;
        this.log = combi.transform.getLogChannel();
        this.ok = false;
        this.finished = false;
        this.doIt = true;
    }

    public String toString() {
        return this.combi.transformName;
    }

    @Override
    public void run() {
        if (!this.doIt) {
            return;
        }
        try {
            this.combi.transform.getLogChannel().snap((IMetrics)Metrics.METRIC_TRANSFORM_INIT_START, new long[0]);
            if (this.combi.transform.init()) {
                this.combi.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_IDLE);
                this.ok = true;
            } else {
                this.combi.transform.setErrors(1L);
                this.log.logError(BaseMessages.getString(PKG, (String)"Pipeline.Log.ErrorInitializingTransform", (String[])new String[]{this.combi.transform.getTransformName()}));
            }
        }
        catch (Throwable e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"Pipeline.Log.ErrorInitializingTransform", (String[])new String[]{this.combi.transform.getTransformName()}));
            this.log.logError(Const.getStackTracker((Throwable)e));
        }
        finally {
            this.combi.transform.getLogChannel().snap((IMetrics)Metrics.METRIC_TRANSFORM_INIT_STOP, new long[0]);
        }
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isOk() {
        return this.ok;
    }

    public TransformMetaDataCombi getCombi() {
        return this.combi;
    }

    public void setCombi(TransformMetaDataCombi combi) {
        this.combi = combi;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public boolean isDoIt() {
        return this.doIt;
    }

    public void setDoIt(boolean doIt) {
        this.doIt = doIt;
    }
}

