/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.local.transaction;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.TransformInitThread;

@ExtensionPoint(id="TransformCreatedXp", extensionPointId="TransformBeforeInitialize", description="If a transform is being created and before it's initialized we copy the connection group")
public class TransformCreatedXp
implements IExtensionPoint<TransformInitThread> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, TransformInitThread initThread) throws HopException {
        ITransform transform = initThread.getCombi().transform;
        Pipeline pipeline = initThread.getPipeline();
        String connectionGroup = (String)pipeline.getExtensionDataMap().get("CONNECTION_GROUP");
        if (connectionGroup != null) {
            transform.getExtensionDataMap().put("CONNECTION_GROUP", connectionGroup);
        }
    }
}

