/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.first;

import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerStoreBase;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.execution.sampler.plugins.first.FirstRowsExecutionDataSampler;

public class FirstRowsExecutionDataSamplerStore
extends ExecutionDataSamplerStoreBase<FirstRowsExecutionDataSamplerStore>
implements IExecutionDataSamplerStore {
    public static final String EXECUTION_DATA_SAMPLE_FIRST_OUTPUT = "FirstOutput";
    private FirstRowsExecutionDataSampler dataSampler;

    public FirstRowsExecutionDataSamplerStore(FirstRowsExecutionDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta, IRowMeta rowMeta, List<Object[]> rows, int maxRows) {
        super(samplerMeta, rowMeta, rows, maxRows);
        this.dataSampler = dataSampler;
        this.samplerMeta = samplerMeta;
        this.rowMeta = rowMeta;
        this.rows = rows;
        this.maxRows = maxRows;
    }

    public FirstRowsExecutionDataSamplerStore(FirstRowsExecutionDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta) {
        this(dataSampler, samplerMeta, null, null, 0);
    }

    @Override
    public FirstRowsExecutionDataSamplerStore getStore() {
        return this;
    }

    @Override
    public void init(IVariables variables, IRowMeta inputRowMeta, IRowMeta outputRowMeta) {
        super.init(variables, inputRowMeta, outputRowMeta);
        this.maxRows = Const.toInt((String)variables.resolve(this.dataSampler.getSampleSize()), (int)0);
    }

    @Override
    public Map<String, RowBuffer> getSamples() {
        return Map.of(this.getKeyForStore(EXECUTION_DATA_SAMPLE_FIRST_OUTPUT, this.samplerMeta), new RowBuffer(this.rowMeta, this.rows));
    }

    @Override
    public Map<String, ExecutionDataSetMeta> getSamplesMetadata() {
        String setKey = this.getKeyForStore(EXECUTION_DATA_SAMPLE_FIRST_OUTPUT, this.samplerMeta);
        String description = "First rows of " + this.getSamplerMeta().getTransformName() + "." + this.getSamplerMeta().getCopyNr();
        ExecutionDataSetMeta meta = new ExecutionDataSetMeta(setKey, this.samplerMeta.getLogChannelId(), this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), description);
        return Map.of(setKey, meta);
    }

    public FirstRowsExecutionDataSampler getDataSampler() {
        return this.dataSampler;
    }

    public void setDataSampler(FirstRowsExecutionDataSampler dataSampler) {
        this.dataSampler = dataSampler;
    }
}

