/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.stream.IStream;

public abstract class ExecutionDataSamplerStoreBase<Store extends IExecutionDataSamplerStore>
implements IExecutionDataSamplerStore {
    protected ExecutionDataSamplerMeta samplerMeta;
    protected IRowMeta rowMeta;
    protected List<Object[]> rows;
    protected int maxRows;

    public abstract Store getStore();

    public ExecutionDataSamplerStoreBase(ExecutionDataSamplerMeta samplerMeta, IRowMeta rowMeta, List<Object[]> rows, int maxRows) {
        this.samplerMeta = samplerMeta;
        this.rowMeta = rowMeta;
        this.rows = rows;
        this.maxRows = maxRows;
    }

    @Override
    public void init(IVariables variables, IRowMeta inputRowMeta, IRowMeta outputRowMeta) {
        this.rows = Collections.synchronizedList(new ArrayList());
    }

    public IRowListener createRowListener(final IExecutionDataSampler sampler) {
        return new IRowListener(){

            @Override
            public void rowReadEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                try {
                    sampler.sampleRow(ExecutionDataSamplerStoreBase.this.getStore(), IStream.StreamType.INPUT, rowMeta, row);
                }
                catch (HopException e) {
                    throw new HopTransformException("Error sampling read row", (Throwable)e);
                }
            }

            @Override
            public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                try {
                    sampler.sampleRow(ExecutionDataSamplerStoreBase.this.getStore(), IStream.StreamType.OUTPUT, rowMeta, row);
                }
                catch (HopException e) {
                    throw new HopTransformException("Error sampling written row", (Throwable)e);
                }
            }

            @Override
            public void errorRowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                try {
                    sampler.sampleRow(ExecutionDataSamplerStoreBase.this.getStore(), IStream.StreamType.ERROR, rowMeta, row);
                }
                catch (HopException e) {
                    throw new HopTransformException("Error sampling error row", (Throwable)e);
                }
            }
        };
    }

    public String getKeyForStore(String prefix, ExecutionDataSamplerMeta meta) {
        return prefix + "/" + meta.toString();
    }

    public ExecutionDataSamplerMeta getSamplerMeta() {
        return this.samplerMeta;
    }

    public void setSamplerMeta(ExecutionDataSamplerMeta samplerMeta) {
        this.samplerMeta = samplerMeta;
    }

    public IRowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    public void setRows(List<Object[]> rows) {
        this.rows = rows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }
}

