/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.hadoopsnappy;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.hop.core.compress.CompressionOutputStream;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.hadoopsnappy.HadoopSnappyCompressionProvider;

public class HadoopSnappyCompressionOutputStream
extends CompressionOutputStream {
    public HadoopSnappyCompressionOutputStream(OutputStream out, ICompressionProvider provider) throws IOException {
        super(HadoopSnappyCompressionOutputStream.getDelegate(out), provider);
    }

    private static OutputStream getDelegate(OutputStream out) throws IOException {
        try {
            return HadoopSnappyCompressionOutputStream.getSnappyOutputStream(out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static OutputStream getSnappyOutputStream(OutputStream out) throws Exception {
        return HadoopSnappyCompressionOutputStream.getSnappyOutputStream(262144, out);
    }

    public static OutputStream getSnappyOutputStream(int bufferSize, OutputStream out) throws Exception {
        if (!HadoopSnappyCompressionProvider.isHadoopSnappyAvailable()) {
            throw new Exception("Hadoop-snappy does not seem to be available");
        }
        Object snappyShim = HadoopSnappyCompressionProvider.getActiveSnappyShim();
        Method getSnappyOutputStream = snappyShim.getClass().getMethod("getSnappyOutputStream", Integer.TYPE, OutputStream.class);
        return (OutputStream)getSnappyOutputStream.invoke(snappyShim, bufferSize, out);
    }
}

