/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.config.plugin.ConfigPluginType;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.HopTwoWayPasswordEncoder;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=HopVersionProvider.class)
public class HopConfig
implements Runnable,
IHasHopMetadataProvider {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Displays this help message and quits."})
    private boolean helpRequested;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information and exit"})
    private boolean versionRequested;
    @CommandLine.Option(names={"-l", "--level"}, description={"The debug level, one of NOTHING, ERROR, MINIMAL, BASIC, DETAILED, DEBUG, ROWLEVEL"})
    private String level;
    private CommandLine cmd;
    private IVariables variables;
    private MultiMetadataProvider metadataProvider;

    @Override
    public void run() {
        try {
            this.variables = Variables.getADefaultVariableSpace();
            LogChannel log = new LogChannel((Object)"hop-config");
            log.setSimplified(true);
            log.setLogLevel(this.determineLogLevel());
            log.logDetailed("Start of Hop Config");
            this.buildMetadataProvider();
            boolean actionTaken = false;
            Map mixins = this.cmd.getMixins();
            for (String key : mixins.keySet()) {
                Object mixin = mixins.get(key);
                if (!(mixin instanceof IConfigOptions)) continue;
                IConfigOptions configOptions = (IConfigOptions)mixin;
                actionTaken = configOptions.handleOption((ILogChannel)log, (IHasHopMetadataProvider)this, this.variables) || actionTaken;
            }
            if (!actionTaken) {
                this.cmd.usage(System.out);
            }
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(this.cmd, "There was an error handling options", (Throwable)e);
        }
    }

    private LogLevel determineLogLevel() {
        return LogLevel.getLogLevelForCode((String)this.variables.resolve(this.level));
    }

    private void buildMetadataProvider() throws HopException {
        ArrayList<JsonMetadataProvider> providers = new ArrayList<JsonMetadataProvider>();
        String folder = this.variables.getVariable("HOP_METADATA_FOLDER");
        if (StringUtils.isEmpty((String)folder)) {
            providers.add(new JsonMetadataProvider());
        } else {
            ITwoWayPasswordEncoder passwordEncoder = Encr.getEncoder();
            if (passwordEncoder == null) {
                passwordEncoder = new HopTwoWayPasswordEncoder();
            }
            providers.add(new JsonMetadataProvider(passwordEncoder, folder, this.variables));
        }
        this.metadataProvider = new MultiMetadataProvider(Encr.getEncoder(), providers, this.variables);
    }

    public CommandLine getCmd() {
        return this.cmd;
    }

    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public static void main(String[] args) {
        HopConfig hopConfig = new HopConfig();
        try {
            HopEnvironment.init();
            CommandLine cmd = new CommandLine((Object)hopConfig);
            List configPlugins = PluginRegistry.getInstance().getPlugins(ConfigPluginType.class);
            for (IPlugin configPlugin : configPlugins) {
                if (!"config".equals(configPlugin.getCategory())) continue;
                IConfigOptions configOptions = (IConfigOptions)PluginRegistry.getInstance().loadClass(configPlugin, IConfigOptions.class);
                cmd.addMixin(configPlugin.getIds()[0], (Object)configOptions);
            }
            hopConfig.setCmd(cmd);
            CommandLine.ParseResult parseResult = cmd.parseArgs(args);
            if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                System.exit(1);
            } else {
                hopConfig.run();
                System.exit(0);
            }
        }
        catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            hopConfig.cmd.usage(System.err);
            e.getCommandLine().usage(System.err);
            System.exit(9);
        }
        catch (CommandLine.ExecutionException e) {
            System.err.println("Error found during execution!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("General error found, something went horribly wrong!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(2);
        }
    }
}

