/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.DataSetCsvUtil;

@ExtensionPoint(id="WriteToDataSetExtensionPoint", extensionPointId="PipelineStartThreads", description="Writes rows of data from a transform into a data set")
public class WriteToDataSetExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public static Map<String, TransformMeta> transformsMap = new HashMap<String, TransformMeta>();
    public static Map<String, List<SourceToTargetMapping>> mappingsMap = new HashMap<String, List<SourceToTargetMapping>>();
    public static Map<String, DataSet> setsMap = new HashMap<String, DataSet>();

    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        PipelineMeta pipelineMeta = pipeline.getPipelineMeta();
        boolean writeToDataSet = "Y".equalsIgnoreCase(pipeline.getVariable("__UnitTest_WriteDataSet__"));
        if (!writeToDataSet) {
            return;
        }
        pipeline.addExecutionFinishedListener(engine -> {
            pipeline.setVariable("__UnitTest_WriteDataSet__", null);
            transformsMap.remove(pipelineMeta.getName());
            mappingsMap.remove(pipelineMeta.getName());
            setsMap.remove(pipelineMeta.getName());
        });
        try {
            IHopMetadataProvider metadataProvider = pipelineMeta.getMetadataProvider();
            if (metadataProvider == null) {
                return;
            }
            for (TransformMeta transformMeta : pipeline.getPipelineMeta().getTransforms()) {
                TransformMeta injectMeta = transformsMap.get(pipelineMeta.getName());
                if (injectMeta == null || !injectMeta.equals((Object)transformMeta)) continue;
                List<SourceToTargetMapping> mappings = mappingsMap.get(pipelineMeta.getName());
                DataSet dataSet = setsMap.get(pipelineMeta.getName());
                if (mappings == null || dataSet == null) continue;
                this.passTransformRowsToDataSet(pipeline, pipelineMeta, transformMeta, mappings, dataSet);
            }
        }
        catch (Throwable e) {
            throw new HopException("Unable to pass rows to data set", e);
        }
    }

    private void passTransformRowsToDataSet(IPipelineEngine<PipelineMeta> pipeline, PipelineMeta pipelineMeta, TransformMeta transformMeta, final List<SourceToTargetMapping> mappings, DataSet dataSet) throws HopException {
        final IRowMeta setRowMeta = dataSet.getSetRowMeta();
        IEngineComponent component = pipeline.findComponent(transformMeta.getName(), 0);
        final ArrayList transformsForDbRows = new ArrayList();
        component.addRowListener((IRowListener)new RowAdapter(){

            public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                Object[] transformForDbRow = RowDataUtil.allocateRowData((int)setRowMeta.size());
                for (SourceToTargetMapping mapping : mappings) {
                    transformForDbRow[mapping.getTargetPosition()] = row[mapping.getSourcePosition()];
                }
                transformsForDbRows.add(transformForDbRow);
            }
        });
        pipeline.addExecutionFinishedListener(engine -> DataSetCsvUtil.writeDataSetData((IVariables)pipeline, dataSet, setRowMeta, transformsForDbRows));
    }
}

