/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@Experimental
@AutoValue
public abstract class KafkaReadSchemaTransformConfiguration {
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_START_OFFSET_VALUES = Sets.newHashSet((Object[])new String[]{"earliest", "latest"});
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])new String[]{"AVRO", "JSON"});

    public void validate() {
        String startOffset = this.getAutoOffsetResetConfig();
        assert (startOffset == null || VALID_START_OFFSET_VALUES.contains(startOffset)) : "Valid Kafka Start offset values are " + VALID_START_OFFSET_VALUES;
        String dataFormat = this.getDataFormat();
        assert (dataFormat == null || VALID_DATA_FORMATS.contains(dataFormat)) : "Valid data formats are " + VALID_DATA_FORMATS;
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_KafkaReadSchemaTransformConfiguration.Builder();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized String getBootstrapServers();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConfluentSchemaRegistryUrl();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getDataFormat();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConfluentSchemaRegistrySubject();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getSchema();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getAutoOffsetResetConfig();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getConsumerConfigUpdates();

    public abstract @UnknownKeyFor @NonNull @Initialized String getTopic();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setBootstrapServers(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setConfluentSchemaRegistryUrl(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setConfluentSchemaRegistrySubject(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setDataFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAutoOffsetResetConfig(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setConsumerConfigUpdates(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopic(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration build();
    }
}

