/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.kafka.ConfluentSchemaRegistryDeserializer;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.kafka.common.serialization.Deserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ConfluentSchemaRegistryDeserializerProvider<@UnknownKeyFor T>
implements DeserializerProvider<T> {
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized SchemaRegistryClient> schemaRegistryClientProviderFn;
    private final @UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl;
    private final @UnknownKeyFor @NonNull @Initialized String subject;
    private final @Nullable @UnknownKeyFor @Initialized Integer version;
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_CACHE_CAPACITY = 1000;

    @VisibleForTesting
    ConfluentSchemaRegistryDeserializerProvider(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized SchemaRegistryClient> schemaRegistryClientProviderFn, @UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl, @UnknownKeyFor @NonNull @Initialized String subject, @Nullable @UnknownKeyFor @Initialized Integer version) {
        Preconditions.checkArgument((schemaRegistryClientProviderFn != null ? 1 : 0) != 0, (Object)"You should provide a schemaRegistryClientProviderFn.");
        Preconditions.checkArgument((schemaRegistryUrl != null ? 1 : 0) != 0, (Object)"You should provide a schemaRegistryUrl.");
        Preconditions.checkArgument((subject != null ? 1 : 0) != 0, (Object)"You should provide a subject to fetch the schema from.");
        this.schemaRegistryClientProviderFn = schemaRegistryClientProviderFn;
        this.schemaRegistryUrl = schemaRegistryUrl;
        this.subject = subject;
        this.version = version;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ConfluentSchemaRegistryDeserializerProvider<T> of(@UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl, @UnknownKeyFor @NonNull @Initialized String subject) {
        return ConfluentSchemaRegistryDeserializerProvider.of(schemaRegistryUrl, 1000, subject, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ConfluentSchemaRegistryDeserializerProvider<T> of(@UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl, @UnknownKeyFor @NonNull @Initialized String subject, @Nullable @UnknownKeyFor @Initialized Integer version) {
        return ConfluentSchemaRegistryDeserializerProvider.of(schemaRegistryUrl, 1000, subject, version, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ConfluentSchemaRegistryDeserializerProvider<T> of(@UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl, @UnknownKeyFor @NonNull @Initialized String subject, @Nullable @UnknownKeyFor @Initialized Integer version, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> schemaRegistryConfigs) {
        return ConfluentSchemaRegistryDeserializerProvider.of(schemaRegistryUrl, 1000, subject, version, schemaRegistryConfigs);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ConfluentSchemaRegistryDeserializerProvider<T> of(@UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl, @UnknownKeyFor @NonNull @Initialized int schemaRegistryCacheCapacity, @UnknownKeyFor @NonNull @Initialized String subject) {
        return ConfluentSchemaRegistryDeserializerProvider.of(schemaRegistryUrl, schemaRegistryCacheCapacity, subject, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ConfluentSchemaRegistryDeserializerProvider<T> of(@UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl, @UnknownKeyFor @NonNull @Initialized int schemaRegistryCacheCapacity, @UnknownKeyFor @NonNull @Initialized String subject, @Nullable @UnknownKeyFor @Initialized Integer version) {
        return ConfluentSchemaRegistryDeserializerProvider.of(schemaRegistryUrl, schemaRegistryCacheCapacity, subject, version, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ConfluentSchemaRegistryDeserializerProvider<T> of(@UnknownKeyFor @NonNull @Initialized String schemaRegistryUrl, @UnknownKeyFor @NonNull @Initialized int schemaRegistryCacheCapacity, @UnknownKeyFor @NonNull @Initialized String subject, @Nullable @UnknownKeyFor @Initialized Integer version, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> schemaRegistryConfigs) {
        return new ConfluentSchemaRegistryDeserializerProvider<T>((SerializableFunction<Void, SchemaRegistryClient>)(SerializableFunction & Serializable)input -> {
            CachedSchemaRegistryClient client = new CachedSchemaRegistryClient(schemaRegistryUrl, schemaRegistryCacheCapacity, schemaRegistryConfigs);
            return client;
        }, schemaRegistryUrl, subject, version);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Deserializer<T> getDeserializer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> configs, @UnknownKeyFor @NonNull @Initialized boolean isKey) {
        HashMap csrConfig = new HashMap(configs);
        csrConfig.put("schema.registry.url", this.schemaRegistryUrl);
        ConfluentSchemaRegistryDeserializer deserializer = new ConfluentSchemaRegistryDeserializer(this.getSchemaRegistryClient(), this.getAvroSchema());
        deserializer.configure(csrConfig, isKey);
        return deserializer;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
        return AvroCoder.of((Schema)this.getAvroSchema());
    }

    private @UnknownKeyFor @NonNull @Initialized Schema getAvroSchema() {
        return new Schema.Parser().parse(this.getSchemaMetadata().getSchema());
    }

    private @UnknownKeyFor @NonNull @Initialized SchemaMetadata getSchemaMetadata() {
        try {
            return this.version == null ? this.getSchemaRegistryClient().getLatestSchemaMetadata(this.subject) : this.getSchemaRegistryClient().getSchemaMetadata(this.subject, this.version.intValue());
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException("Unable to get latest schema metadata for subject: " + this.subject, e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized SchemaRegistryClient getSchemaRegistryClient() {
        return (SchemaRegistryClient)this.schemaRegistryClientProviderFn.apply(null);
    }
}

