/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaWriteSchemaTransformProvider;

final class AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration
extends KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration {
    private final String format;
    private final String topic;
    private final String bootstrapServers;
    private final Map<String, String> producerConfigUpdates;

    private AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration(String format, String topic, String bootstrapServers, @Nullable Map<String, String> producerConfigUpdates) {
        this.format = format;
        this.topic = topic;
        this.bootstrapServers = bootstrapServers;
        this.producerConfigUpdates = producerConfigUpdates;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    @Nullable
    public Map<String, String> getProducerConfigUpdates() {
        return this.producerConfigUpdates;
    }

    public String toString() {
        return "KafkaWriteSchemaTransformConfiguration{format=" + this.format + ", topic=" + this.topic + ", bootstrapServers=" + this.bootstrapServers + ", producerConfigUpdates=" + this.producerConfigUpdates + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration) {
            KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration that = (KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && this.topic.equals(that.getTopic()) && this.bootstrapServers.equals(that.getBootstrapServers()) && (this.producerConfigUpdates == null ? that.getProducerConfigUpdates() == null : this.producerConfigUpdates.equals(that.getProducerConfigUpdates()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.bootstrapServers.hashCode();
        h$ *= 1000003;
        return h$ ^= this.producerConfigUpdates == null ? 0 : this.producerConfigUpdates.hashCode();
    }

    static final class Builder
    extends KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder {
        private String format;
        private String topic;
        private String bootstrapServers;
        private Map<String, String> producerConfigUpdates;

        Builder() {
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setBootstrapServers(String bootstrapServers) {
            if (bootstrapServers == null) {
                throw new NullPointerException("Null bootstrapServers");
            }
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration.Builder setProducerConfigUpdates(Map<String, String> producerConfigUpdates) {
            this.producerConfigUpdates = producerConfigUpdates;
            return this;
        }

        @Override
        public KafkaWriteSchemaTransformProvider.KafkaWriteSchemaTransformConfiguration build() {
            if (this.format == null || this.topic == null || this.bootstrapServers == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.topic == null) {
                    missing.append(" topic");
                }
                if (this.bootstrapServers == null) {
                    missing.append(" bootstrapServers");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration(this.format, this.topic, this.bootstrapServers, this.producerConfigUpdates);
        }
    }
}

