/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.LargeStringBuffer;
import net.sf.saxon.tinytree.TinyAttributeImpl;
import net.sf.saxon.tinytree.TinyCommentImpl;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyProcInstImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.WhitespaceTextImpl;
import net.sf.saxon.tree.LineNumberMap;
import net.sf.saxon.tree.SystemIdMap;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.UntypedAtomicValue;

public final class TinyTree {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Configuration config;
    private ArrayList documentList = new ArrayList(5);
    protected int documentNumber;
    protected LargeStringBuffer charBuffer;
    protected FastStringBuffer commentBuffer = null;
    protected int numberOfNodes = 0;
    public byte[] nodeKind;
    protected short[] depth;
    protected int[] next;
    protected int[] alpha;
    protected int[] beta;
    protected int[] nameCode;
    protected int[] prior = null;
    protected int[] typeCodeArray = null;
    protected int numberOfAttributes = 0;
    protected int[] attParent;
    protected int[] attCode;
    protected CharSequence[] attValue;
    protected int[] attTypeCode;
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent;
    protected int[] namespaceCode;
    private int[] rootIndex = new int[5];
    private int rootIndexUsed = 0;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = null;
    protected boolean usesNamespaces = false;
    private IntHashSet nonIDs;
    private static int treesCreated = 5;
    private static double averageNodes = 4000.0;
    private static double averageAttributes = 100.0;
    private static double averageNamespaces = 20.0;
    private static double averageCharacters = 4000.0;

    public TinyTree() {
        this((int)(averageNodes + 1.0), (int)(averageAttributes + 1.0), (int)(averageNamespaces + 1.0), (int)(averageCharacters + 1.0));
    }

    public TinyTree(int n, int n2, int n3, int n4) {
        this.nodeKind = new byte[n];
        this.depth = new short[n];
        this.next = new int[n];
        this.alpha = new int[n];
        this.beta = new int[n];
        this.nameCode = new int[n];
        this.numberOfAttributes = 0;
        this.attParent = new int[n2];
        this.attCode = new int[n2];
        this.attValue = new String[n2];
        this.numberOfNamespaces = 0;
        this.namespaceParent = new int[n3];
        this.namespaceCode = new int[n3];
        this.charBuffer = new LargeStringBuffer(n4, 64000);
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.addNamespace(0, 65537);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    private void ensureNodeCapacity(short s) {
        if (this.nodeKind.length < this.numberOfNodes + 1) {
            int n = s == 11 ? this.numberOfNodes + 1 : this.numberOfNodes * 2;
            byte[] byArray = new byte[n];
            int[] nArray = new int[n];
            short[] sArray = new short[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            System.arraycopy(this.nodeKind, 0, byArray, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, sArray, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            this.nodeKind = byArray;
            this.next = nArray;
            this.depth = sArray;
            this.alpha = nArray2;
            this.beta = nArray3;
            this.nameCode = nArray4;
            if (this.typeCodeArray != null) {
                int[] nArray5 = new int[n];
                System.arraycopy(this.typeCodeArray, 0, nArray5, 0, this.numberOfNodes);
                this.typeCodeArray = nArray5;
            }
        }
    }

    private void ensureAttributeCapacity() {
        if (this.attParent.length < this.numberOfAttributes + 1) {
            int n = this.numberOfAttributes * 2;
            if (n == 0) {
                n = 10;
            }
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray = new String[n];
            System.arraycopy(this.attParent, 0, nArray, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, stringArray, 0, this.numberOfAttributes);
            this.attParent = nArray;
            this.attCode = nArray2;
            this.attValue = stringArray;
            if (this.attTypeCode != null) {
                int[] nArray3 = new int[n];
                System.arraycopy(this.attTypeCode, 0, nArray3, 0, this.numberOfAttributes);
                this.attTypeCode = nArray3;
            }
        }
    }

    private void ensureNamespaceCapacity() {
        if (this.namespaceParent.length < this.numberOfNamespaces + 1) {
            int n = this.numberOfNamespaces * 2;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.namespaceParent, 0, nArray, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = nArray;
            this.namespaceCode = nArray2;
        }
    }

    void addDocumentNode(TinyDocumentImpl tinyDocumentImpl) {
        this.documentList.add(tinyDocumentImpl);
        this.addNode((short)9, 0, this.documentList.size() - 1, 0, -1);
    }

    int addNode(short s, int n, int n2, int n3, int n4) {
        this.ensureNodeCapacity(s);
        this.nodeKind[this.numberOfNodes] = (byte)s;
        this.depth[this.numberOfNodes] = (short)n;
        this.alpha[this.numberOfNodes] = n2;
        this.beta[this.numberOfNodes] = n3;
        this.nameCode[this.numberOfNodes] = n4;
        this.next[this.numberOfNodes] = -1;
        if (this.typeCodeArray != null) {
            this.typeCodeArray[this.numberOfNodes] = 641;
        }
        if (this.numberOfNodes == 0) {
            this.documentNumber = this.config.getDocumentNumberAllocator().allocateDocumentNumber();
        }
        if (n == 0 && s != 11) {
            if (this.rootIndexUsed == this.rootIndex.length) {
                int[] nArray = new int[this.rootIndexUsed * 2];
                System.arraycopy(this.rootIndex, 0, nArray, 0, this.rootIndexUsed);
                this.rootIndex = nArray;
            }
            this.rootIndex[this.rootIndexUsed++] = this.numberOfNodes;
        }
        return this.numberOfNodes++;
    }

    void appendChars(CharSequence charSequence) {
        this.charBuffer.append(charSequence);
    }

    protected void condense() {
        int[] nArray;
        Object[] objectArray;
        int[] nArray2;
        Object[] objectArray2;
        int n;
        if (this.rootIndexUsed > 1) {
            return;
        }
        if (this.numberOfNodes * 3 < this.nodeKind.length || this.nodeKind.length - this.numberOfNodes > 20000) {
            n = this.numberOfNodes + 1;
            objectArray2 = new byte[n];
            nArray2 = new int[n];
            objectArray = new short[n];
            nArray = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            System.arraycopy(this.nodeKind, 0, objectArray2, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, objectArray, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            if (this.typeCodeArray != null) {
                int[] nArray5 = new int[n];
                System.arraycopy(this.typeCodeArray, 0, nArray5, 0, this.numberOfNodes);
                this.typeCodeArray = nArray5;
            }
            this.nodeKind = objectArray2;
            this.next = nArray2;
            this.depth = objectArray;
            this.alpha = nArray;
            this.beta = nArray3;
            this.nameCode = nArray4;
        }
        if (this.numberOfAttributes * 3 < this.attParent.length || this.attParent.length - this.numberOfAttributes > 1000) {
            n = this.numberOfAttributes;
            if (n == 0) {
                this.attParent = EMPTY_INT_ARRAY;
                this.attCode = EMPTY_INT_ARRAY;
                this.attValue = EMPTY_STRING_ARRAY;
                this.attTypeCode = null;
            }
            objectArray2 = new int[n];
            nArray2 = new int[n];
            objectArray = new String[n];
            System.arraycopy(this.attParent, 0, objectArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, objectArray, 0, this.numberOfAttributes);
            this.attParent = objectArray2;
            this.attCode = nArray2;
            this.attValue = (CharSequence[])objectArray;
            if (this.attTypeCode != null) {
                nArray = new int[n];
                System.arraycopy(this.attTypeCode, 0, nArray, 0, this.numberOfAttributes);
                this.attTypeCode = nArray;
            }
        }
        if (this.numberOfNamespaces * 3 < this.namespaceParent.length) {
            n = this.numberOfNamespaces;
            objectArray2 = new int[n];
            nArray2 = new int[n];
            System.arraycopy(this.namespaceParent, 0, objectArray2, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = objectArray2;
            this.namespaceCode = nArray2;
        }
        this.updateStatistics();
    }

    void setElementAnnotation(int n, int n2) {
        if (n2 != 641) {
            if (this.typeCodeArray == null) {
                this.typeCodeArray = new int[this.nodeKind.length];
                for (int i = 0; i < this.nodeKind.length; ++i) {
                    this.typeCodeArray[i] = 641;
                }
            }
            this.typeCodeArray[n] = n2;
        }
    }

    public int getTypeAnnotation(int n) {
        if (this.typeCodeArray == null) {
            return 641;
        }
        return this.typeCodeArray[n];
    }

    public int getNodeKind(int n) {
        int n2 = this.nodeKind[n];
        return n2 == 4 ? 3 : n2;
    }

    public int getNameCode(int n) {
        return this.nameCode[n];
    }

    void ensurePriorIndex() {
        if (this.prior == null) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        int n;
        this.prior = new int[this.numberOfNodes];
        for (n = 0; n < this.numberOfNodes; ++n) {
            this.prior[n] = -1;
        }
        for (n = 0; n < this.numberOfNodes; ++n) {
            int n2 = this.next[n];
            if (n2 <= n) continue;
            this.prior[n2] = n;
        }
    }

    void addAttribute(NodeInfo nodeInfo, int n, int n2, int n3, CharSequence charSequence) {
        this.ensureAttributeCapacity();
        this.attParent[this.numberOfAttributes] = n;
        this.attCode[this.numberOfAttributes] = n2;
        this.attValue[this.numberOfAttributes] = charSequence;
        if (n3 == -1) {
            n3 = 642;
        }
        if (n3 != 642 && this.attTypeCode == null) {
            this.attTypeCode = new int[this.attParent.length];
            for (int i = 0; i < this.numberOfAttributes; ++i) {
                this.attTypeCode[i] = 642;
            }
        }
        if (this.attTypeCode != null) {
            this.attTypeCode[this.numberOfAttributes] = n3;
        }
        if (this.alpha[n] == -1) {
            this.alpha[n] = this.numberOfAttributes;
        }
        if (nodeInfo instanceof TinyDocumentImpl && (this.isIDCode(n3) || (n2 & 0xFFFFF) == 388)) {
            String string = ((Object)charSequence).toString().trim();
            if (nodeInfo.getConfiguration().getNameChecker().isValidNCName(string)) {
                TinyNodeImpl tinyNodeImpl = this.getNode(n);
                ((TinyDocumentImpl)nodeInfo).registerID(tinyNodeImpl, string);
            } else if (this.attTypeCode != null) {
                this.attTypeCode[this.numberOfAttributes] = 642;
            }
        }
        ++this.numberOfAttributes;
    }

    public void indexIDElement(NodeInfo nodeInfo, int n, NameChecker nameChecker) {
        String string = ((Object)TinyParentNodeImpl.getStringValue(this, n)).toString().trim();
        if (nodeInfo.getNodeKind() == 9 && nameChecker.isValidNCName(string)) {
            TinyNodeImpl tinyNodeImpl = this.getNode(n);
            ((TinyDocumentImpl)nodeInfo).registerID(tinyNodeImpl, string);
        }
    }

    public boolean isIDCode(int n) {
        if ((n &= 0xFFFFF) == 560) {
            return true;
        }
        if (n < 1024) {
            return false;
        }
        if (this.nonIDs == null) {
            this.nonIDs = new IntHashSet(20);
        }
        if (this.nonIDs.contains(n)) {
            return false;
        }
        SchemaType schemaType = this.getConfiguration().getSchemaType(n);
        if (schemaType instanceof AtomicType) {
            TypeHierarchy typeHierarchy = this.getConfiguration().getNamePool().getTypeHierarchy();
            if (typeHierarchy.isSubType((AtomicType)schemaType, Type.ID_TYPE)) {
                return true;
            }
            this.nonIDs.add(n);
            return false;
        }
        return false;
    }

    void addNamespace(int n, int n2) {
        this.ensureNamespaceCapacity();
        this.namespaceParent[this.numberOfNamespaces] = n;
        this.namespaceCode[this.numberOfNamespaces] = n2;
        if (this.beta[n] == -1) {
            this.beta[n] = this.numberOfNamespaces;
        }
        ++this.numberOfNamespaces;
        if (n2 != 65537) {
            this.usesNamespaces = true;
        }
    }

    public TinyNodeImpl getNode(int n) {
        switch (this.nodeKind[n]) {
            case 9: {
                return (TinyDocumentImpl)this.documentList.get(this.alpha[n]);
            }
            case 1: {
                return new TinyElementImpl(this, n);
            }
            case 3: {
                return new TinyTextImpl(this, n);
            }
            case 4: {
                return new WhitespaceTextImpl(this, n);
            }
            case 8: {
                return new TinyCommentImpl(this, n);
            }
            case 7: {
                return new TinyProcInstImpl(this, n);
            }
            case 12: {
                throw new IllegalArgumentException("Attempting to treat a parent pointer as a node");
            }
        }
        return null;
    }

    UntypedAtomicValue getUntypedAtomicValue(int n) {
        switch (this.nodeKind[n]) {
            case 1: 
            case 9: {
                int n2;
                short s = this.depth[n];
                if (this.depth[n2] <= s) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                if (this.nodeKind[n2] == 3 && this.depth[n2 + 1] <= s) {
                    int n3 = this.beta[n2];
                    int n4 = this.alpha[n2];
                    return new UntypedAtomicValue(this.charBuffer.subSequence(n4, n4 + n3));
                }
                FastStringBuffer fastStringBuffer = null;
                for (n2 = n + 1; n2 < this.numberOfNodes && this.depth[n2] > s; ++n2) {
                    if (this.nodeKind[n2] != 3) continue;
                    if (fastStringBuffer == null) {
                        fastStringBuffer = new FastStringBuffer(1024);
                    }
                    fastStringBuffer.append(TinyTextImpl.getStringValue(this, n2));
                }
                if (fastStringBuffer == null) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                return new UntypedAtomicValue(fastStringBuffer.condense());
            }
            case 3: {
                return new UntypedAtomicValue(TinyTextImpl.getStringValue(this, n));
            }
            case 4: {
                return new UntypedAtomicValue(WhitespaceTextImpl.getStringValue(this, n));
            }
            case 7: 
            case 8: {
                int n5 = this.alpha[n];
                int n6 = this.beta[n];
                if (n6 == 0) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                char[] cArray = new char[n6];
                this.commentBuffer.getChars(n5, n5 + n6, cArray, 0);
                return new UntypedAtomicValue(new CharSlice(cArray, 0, n6));
            }
        }
        throw new IllegalStateException("Unknown node kind");
    }

    TinyAttributeImpl getAttributeNode(int n) {
        return new TinyAttributeImpl(this, n);
    }

    int getAttributeAnnotation(int n) {
        if (this.attTypeCode == null) {
            return 642;
        }
        return this.attTypeCode[n] & 0x400FFFFF;
    }

    boolean isIdref(int n) {
        if (this.attTypeCode == null) {
            return false;
        }
        int n2 = this.attTypeCode[n];
        if ((this.attTypeCode[n] & 0x40000000) != 0) {
            return true;
        }
        if (n2 == 642) {
            return false;
        }
        if (n2 == 561) {
            return true;
        }
        if (n2 == 562) {
            return true;
        }
        if (n2 < 1024) {
            return false;
        }
        SchemaType schemaType = this.getConfiguration().getSchemaType(n2);
        TypeHierarchy typeHierarchy = this.getConfiguration().getNamePool().getTypeHierarchy();
        if (schemaType instanceof AtomicType) {
            return typeHierarchy.isSubType((AtomicType)schemaType, (AtomicType)BuiltInSchemaFactory.getSchemaType(561));
        }
        if (schemaType instanceof ListType) {
            SimpleType simpleType = ((ListType)schemaType).getItemType();
            if (!(simpleType instanceof AtomicType)) {
                return false;
            }
            return typeHierarchy.isSubType((AtomicType)simpleType, (AtomicType)BuiltInSchemaFactory.getSchemaType(561));
        }
        return false;
    }

    void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(n, string);
    }

    String getSystemId(int n) {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(n);
    }

    int getRootNode(int n) {
        for (int i = this.rootIndexUsed - 1; i >= 0; --i) {
            if (this.rootIndex[i] > n) continue;
            return this.rootIndex[i];
        }
        return 0;
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(0, 0);
    }

    void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public boolean isNilled(int n) {
        if (this.nodeKind[n] != 1) {
            return false;
        }
        if (this.typeCodeArray == null || this.typeCodeArray[n] == -1 || this.typeCodeArray[n] == 641) {
            return false;
        }
        int n2 = this.alpha[n];
        if (n2 > 0) {
            while (this.attParent[n2] == n && n2 < this.numberOfAttributes) {
                String string;
                if (this.attCode[n2] == 770 && ((string = ((Object)this.attValue[n2]).toString().trim()).equals("1") || string.equals("true"))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void diagnosticDump() {
        int n;
        System.err.println("    node    type   depth    next   alpha    beta    name");
        for (n = 0; n < this.numberOfNodes; ++n) {
            System.err.println(this.n8(n) + this.n8(this.nodeKind[n]) + this.n8(this.depth[n]) + this.n8(this.next[n]) + this.n8(this.alpha[n]) + this.n8(this.beta[n]) + this.n8(this.nameCode[n]));
        }
        System.err.println("    attr  parent    name    value");
        for (n = 0; n < this.numberOfAttributes; ++n) {
            System.err.println(this.n8(n) + this.n8(this.attParent[n]) + this.n8(this.attCode[n]) + "    " + this.attValue[n]);
        }
        System.err.println("      ns  parent  prefix     uri");
        for (n = 0; n < this.numberOfNamespaces; ++n) {
            System.err.println(this.n8(n) + this.n8(this.namespaceParent[n]) + this.n8(this.namespaceCode[n] >> 16) + this.n8(this.namespaceCode[n] & 0xFFFF));
        }
    }

    private String n8(int n) {
        String string = "        " + n;
        return string.substring(string.length() - 8);
    }

    public void showSize() {
        System.err.println("Tree size: " + this.numberOfNodes + " nodes, " + this.charBuffer.length() + " characters, " + this.numberOfAttributes + " attributes");
    }

    private void updateStatistics() {
        int n;
        int n2 = treesCreated;
        treesCreated = n = treesCreated + 1;
        if ((averageNodes = (averageNodes * (double)n2 + (double)this.numberOfNodes) / (double)n) < 10.0) {
            averageNodes = 10.0;
        }
        if ((averageAttributes = (averageAttributes * (double)n2 + (double)this.numberOfAttributes) / (double)n) < 10.0) {
            averageAttributes = 10.0;
        }
        if ((averageNamespaces = (averageNamespaces * (double)n2 + (double)this.numberOfNamespaces) / (double)n) < 5.0) {
            averageNamespaces = 5.0;
        }
        if ((averageCharacters = (averageCharacters * (double)n2 + (double)this.charBuffer.length()) / (double)n) < 100.0) {
            averageCharacters = 100.0;
        }
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public int getNumberOfNamespaces() {
        return this.numberOfNamespaces;
    }

    public byte[] getNodeKindArray() {
        return this.nodeKind;
    }

    public short[] getNodeDepthArray() {
        return this.depth;
    }

    public int[] getNameCodeArray() {
        return this.nameCode;
    }

    public int[] getTypeCodeArray() {
        return this.typeCodeArray;
    }

    public int[] getNextPointerArray() {
        return this.next;
    }

    public int[] getAlphaArray() {
        return this.alpha;
    }

    public int[] getBetaArray() {
        return this.beta;
    }

    public CharSequence getCharacterBuffer() {
        return this.charBuffer;
    }

    public CharSequence getCommentBuffer() {
        return this.commentBuffer;
    }

    public int[] getAttributeNameCodeArray() {
        return this.attCode;
    }

    public int[] getAttributeTypeCodeArray() {
        return this.attTypeCode;
    }

    public int[] getAttributeParentArray() {
        return this.attParent;
    }

    public CharSequence[] getAttributeValueArray() {
        return this.attValue;
    }

    public int[] getNamespaceCodeArray() {
        return this.namespaceCode;
    }

    public int[] getNamespaceParentArray() {
        return this.namespaceParent;
    }
}

