/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.io.Serializable;
import java.util.Arrays;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class StateReference
implements Serializable {
    private static final long serialVersionUID = 7385215386971310699L;
    private Address address;
    private transient TransportMapping transportMapping;
    private byte[] contextEngineID;
    private byte[] contextName;
    private SecurityModel securityModel;
    private byte[] securityName;
    private int securityLevel;
    private SecurityStateReference securityStateReference;
    private int msgID;
    private int maxSizeResponseScopedPDU;
    private int msgFlags;
    private PduHandle pduHandle;
    private byte[] securityEngineID;
    private int errorCode = 0;

    public StateReference() {
    }

    public StateReference(PduHandle pduHandle, Address address, TransportMapping transportMapping, SecurityModel securityModel, byte[] byArray, int n) {
        this(0, 0, 65535, pduHandle, address, transportMapping, null, securityModel, byArray, 1, null, null, null, n);
    }

    public StateReference(int n, int n2, int n3, PduHandle pduHandle, Address address, TransportMapping transportMapping, byte[] byArray, SecurityModel securityModel, byte[] byArray2, int n4, byte[] byArray3, byte[] byArray4, SecurityStateReference securityStateReference, int n5) {
        this.msgID = n;
        this.msgFlags = n2;
        this.maxSizeResponseScopedPDU = n3;
        this.pduHandle = pduHandle;
        this.address = address;
        this.transportMapping = transportMapping;
        this.securityEngineID = byArray;
        this.securityModel = securityModel;
        this.securityName = byArray2;
        this.securityLevel = n4;
        this.contextEngineID = byArray3;
        this.contextName = byArray4;
        this.securityStateReference = securityStateReference;
        this.errorCode = n5;
    }

    public boolean isReportable() {
        return (this.msgFlags & 4) > 0;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setContextEngineID(byte[] byArray) {
        this.contextEngineID = byArray;
    }

    public byte[] getContextEngineID() {
        return this.contextEngineID;
    }

    public void setContextName(byte[] byArray) {
        this.contextName = byArray;
    }

    public byte[] getContextName() {
        return this.contextName;
    }

    public void setSecurityModel(SecurityModel securityModel) {
        this.securityModel = securityModel;
    }

    public SecurityModel getSecurityModel() {
        return this.securityModel;
    }

    public void setSecurityName(byte[] byArray) {
        this.securityName = byArray;
    }

    public byte[] getSecurityName() {
        return this.securityName;
    }

    public void setSecurityLevel(int n) {
        this.securityLevel = n;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityStateReference(SecurityStateReference securityStateReference) {
        this.securityStateReference = securityStateReference;
    }

    public SecurityStateReference getSecurityStateReference() {
        return this.securityStateReference;
    }

    public void setMsgID(int n) {
        this.msgID = n;
    }

    public int getMsgID() {
        return this.msgID;
    }

    public void setMsgFlags(int n) {
        this.msgFlags = n;
    }

    public int getMsgFlags() {
        return this.msgFlags;
    }

    public void setMaxSizeResponseScopedPDU(int n) {
        this.maxSizeResponseScopedPDU = n;
    }

    public int getMaxSizeResponseScopedPDU() {
        return this.maxSizeResponseScopedPDU;
    }

    public PduHandle getPduHandle() {
        return this.pduHandle;
    }

    public byte[] getSecurityEngineID() {
        return this.securityEngineID;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public TransportMapping getTransportMapping() {
        return this.transportMapping;
    }

    public void setPduHandle(PduHandle pduHandle) {
        this.pduHandle = pduHandle;
    }

    public void setSecurityEngineID(byte[] byArray) {
        this.securityEngineID = byArray;
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public void setTransportMapping(TransportMapping transportMapping) {
        this.transportMapping = transportMapping;
    }

    public boolean equals(Object object) {
        if (object instanceof StateReference) {
            StateReference stateReference = (StateReference)object;
            return this.msgID == stateReference.msgID && this.pduHandle == null && stateReference.pduHandle == null || this.pduHandle != null && this.pduHandle.equals(stateReference.getPduHandle()) && Arrays.equals(this.securityEngineID, stateReference.securityEngineID) && this.securityModel.equals(stateReference.securityModel) && Arrays.equals(this.securityName, stateReference.securityName) && this.securityLevel == stateReference.securityLevel && Arrays.equals(this.contextEngineID, stateReference.contextEngineID) && Arrays.equals(this.contextName, stateReference.contextName);
        }
        return false;
    }

    public int hashCode() {
        return this.msgID;
    }

    public String toString() {
        return "StateReference[msgID=" + this.msgID + ",pduHandle=" + this.pduHandle + ",securityEngineID=" + OctetString.fromByteArray(this.securityEngineID) + ",securityModel=" + this.securityModel + ",securityName=" + OctetString.fromByteArray(this.securityName) + ",securityLevel=" + this.securityLevel + ",contextEngineID=" + OctetString.fromByteArray(this.contextEngineID) + ",contextName=" + OctetString.fromByteArray(this.contextName) + "]";
    }
}

