/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class SingleUserLock {
    protected final Date created;
    protected final String lockHolderAccountId;
    protected final String lockHolderTeamId;

    public SingleUserLock(Date created, String lockHolderAccountId, String lockHolderTeamId) {
        if (created == null) {
            throw new IllegalArgumentException("Required value for 'created' is null");
        }
        this.created = LangUtil.truncateMillis(created);
        if (lockHolderAccountId == null) {
            throw new IllegalArgumentException("Required value for 'lockHolderAccountId' is null");
        }
        if (lockHolderAccountId.length() < 40) {
            throw new IllegalArgumentException("String 'lockHolderAccountId' is shorter than 40");
        }
        if (lockHolderAccountId.length() > 40) {
            throw new IllegalArgumentException("String 'lockHolderAccountId' is longer than 40");
        }
        this.lockHolderAccountId = lockHolderAccountId;
        this.lockHolderTeamId = lockHolderTeamId;
    }

    public SingleUserLock(Date created, String lockHolderAccountId) {
        this(created, lockHolderAccountId, null);
    }

    public Date getCreated() {
        return this.created;
    }

    public String getLockHolderAccountId() {
        return this.lockHolderAccountId;
    }

    public String getLockHolderTeamId() {
        return this.lockHolderTeamId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.created, this.lockHolderAccountId, this.lockHolderTeamId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SingleUserLock other = (SingleUserLock)obj;
            return !(this.created != other.created && !this.created.equals(other.created) || this.lockHolderAccountId != other.lockHolderAccountId && !this.lockHolderAccountId.equals(other.lockHolderAccountId) || this.lockHolderTeamId != other.lockHolderTeamId && (this.lockHolderTeamId == null || !this.lockHolderTeamId.equals(other.lockHolderTeamId)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SingleUserLock> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SingleUserLock value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("created");
            StoneSerializers.timestamp().serialize(value.created, g);
            g.writeFieldName("lock_holder_account_id");
            StoneSerializers.string().serialize(value.lockHolderAccountId, g);
            if (value.lockHolderTeamId != null) {
                g.writeFieldName("lock_holder_team_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.lockHolderTeamId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SingleUserLock deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_lockHolderTeamId;
            String f_lockHolderAccountId;
            Date f_created;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_created = null;
                f_lockHolderAccountId = null;
                f_lockHolderTeamId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("lock_holder_account_id".equals(field)) {
                        f_lockHolderAccountId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("lock_holder_team_id".equals(field)) {
                        f_lockHolderTeamId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_created == null) {
                    throw new JsonParseException(p, "Required field \"created\" missing.");
                }
                if (f_lockHolderAccountId == null) {
                    throw new JsonParseException(p, "Required field \"lock_holder_account_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SingleUserLock value = new SingleUserLock(f_created, f_lockHolderAccountId, f_lockHolderTeamId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

