/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.clouddocs.CloudDocsAccessError;
import com.dropbox.core.v2.clouddocs.CloudDocsAccessErrorException;
import com.dropbox.core.v2.clouddocs.Content;
import com.dropbox.core.v2.clouddocs.GetContentArg;
import com.dropbox.core.v2.clouddocs.GetContentBuilder;
import com.dropbox.core.v2.clouddocs.GetMetadataArg;
import com.dropbox.core.v2.clouddocs.GetMetadataError;
import com.dropbox.core.v2.clouddocs.GetMetadataErrorException;
import com.dropbox.core.v2.clouddocs.GetMetadataResult;
import com.dropbox.core.v2.clouddocs.LockArg;
import com.dropbox.core.v2.clouddocs.LockResult;
import com.dropbox.core.v2.clouddocs.LockingError;
import com.dropbox.core.v2.clouddocs.LockingErrorException;
import com.dropbox.core.v2.clouddocs.RenameArg;
import com.dropbox.core.v2.clouddocs.RenameBuilder;
import com.dropbox.core.v2.clouddocs.RenameError;
import com.dropbox.core.v2.clouddocs.RenameErrorException;
import com.dropbox.core.v2.clouddocs.RenameResult;
import com.dropbox.core.v2.clouddocs.UnlockArg;
import com.dropbox.core.v2.clouddocs.UnlockResult;
import com.dropbox.core.v2.clouddocs.UpdateContentArg;
import com.dropbox.core.v2.clouddocs.UpdateContentUploader;
import java.util.Collections;
import java.util.List;

public class DbxUserCloudDocsRequests {
    private final DbxRawClientV2 client;

    public DbxUserCloudDocsRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    DbxDownloader<Void> getContent(GetContentArg arg, List<HttpRequestor.Header> _headers) throws CloudDocsAccessErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/cloud_docs/get_content", arg, false, _headers, GetContentArg.Serializer.INSTANCE, StoneSerializers.void_(), CloudDocsAccessError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new CloudDocsAccessErrorException("2/cloud_docs/get_content", ex.getRequestId(), ex.getUserMessage(), (CloudDocsAccessError)((Object)ex.getErrorValue()));
        }
    }

    public DbxDownloader<Void> getContent(String fileId) throws CloudDocsAccessErrorException, DbxException {
        GetContentArg _arg = new GetContentArg(fileId);
        return this.getContent(_arg, Collections.emptyList());
    }

    public GetContentBuilder getContentBuilder(String fileId) {
        return new GetContentBuilder(this, fileId);
    }

    GetMetadataResult getMetadata(GetMetadataArg arg) throws GetMetadataErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/cloud_docs/get_metadata", arg, false, GetMetadataArg.Serializer.INSTANCE, GetMetadataResult.Serializer.INSTANCE, GetMetadataError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new GetMetadataErrorException("2/cloud_docs/get_metadata", ex.getRequestId(), ex.getUserMessage(), (GetMetadataError)ex.getErrorValue());
        }
    }

    public GetMetadataResult getMetadata() throws GetMetadataErrorException, DbxException {
        GetMetadataArg _arg = new GetMetadataArg();
        return this.getMetadata(_arg);
    }

    public GetMetadataResult getMetadata(String fileId) throws GetMetadataErrorException, DbxException {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        GetMetadataArg _arg = new GetMetadataArg(fileId);
        return this.getMetadata(_arg);
    }

    LockResult lock(LockArg arg) throws LockingErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/cloud_docs/lock", arg, false, LockArg.Serializer.INSTANCE, LockResult.Serializer.INSTANCE, LockingError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new LockingErrorException("2/cloud_docs/lock", ex.getRequestId(), ex.getUserMessage(), (LockingError)ex.getErrorValue());
        }
    }

    public LockResult lock() throws LockingErrorException, DbxException {
        LockArg _arg = new LockArg();
        return this.lock(_arg);
    }

    public LockResult lock(String fileId) throws LockingErrorException, DbxException {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        LockArg _arg = new LockArg(fileId);
        return this.lock(_arg);
    }

    RenameResult rename(RenameArg arg) throws RenameErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/cloud_docs/rename", arg, false, RenameArg.Serializer.INSTANCE, RenameResult.Serializer.INSTANCE, RenameError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new RenameErrorException("2/cloud_docs/rename", ex.getRequestId(), ex.getUserMessage(), (RenameError)ex.getErrorValue());
        }
    }

    public RenameResult rename() throws RenameErrorException, DbxException {
        RenameArg _arg = new RenameArg();
        return this.rename(_arg);
    }

    public RenameBuilder renameBuilder() {
        RenameArg.Builder argBuilder_ = RenameArg.newBuilder();
        return new RenameBuilder(this, argBuilder_);
    }

    UnlockResult unlock(UnlockArg arg) throws LockingErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/cloud_docs/unlock", arg, false, UnlockArg.Serializer.INSTANCE, UnlockResult.Serializer.INSTANCE, LockingError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new LockingErrorException("2/cloud_docs/unlock", ex.getRequestId(), ex.getUserMessage(), (LockingError)ex.getErrorValue());
        }
    }

    public UnlockResult unlock() throws LockingErrorException, DbxException {
        UnlockArg _arg = new UnlockArg();
        return this.unlock(_arg);
    }

    public UnlockResult unlock(String fileId) throws LockingErrorException, DbxException {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        UnlockArg _arg = new UnlockArg(fileId);
        return this.unlock(_arg);
    }

    UpdateContentUploader updateContent(UpdateContentArg arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/cloud_docs/update_content", arg, false, UpdateContentArg.Serializer.INSTANCE);
        return new UpdateContentUploader(_uploader, this.client.getUserId());
    }

    public UpdateContentUploader updateContent(String fileId, List<String> actorTokens) throws DbxException {
        UpdateContentArg _arg = new UpdateContentArg(fileId, actorTokens);
        return this.updateContent(_arg);
    }

    public UpdateContentUploader updateContent(String fileId, List<String> actorTokens, List<Content> additionalContents) throws DbxException {
        if (additionalContents != null) {
            for (Content x : additionalContents) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'additionalContents' is null");
            }
        }
        UpdateContentArg _arg = new UpdateContentArg(fileId, actorTokens, additionalContents);
        return this.updateContent(_arg);
    }
}

