/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxOAuth1AccessToken;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public final class DbxOAuth1Upgrader {
    private final DbxRequestConfig requestConfig;
    private final DbxAppInfo appInfo;
    public static final JsonReader<String> ResponseReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String accessToken = null;
            String tokenType = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                JsonReader.nextToken(parser);
                try {
                    if (fieldName.equals("token_type")) {
                        tokenType = DbxAuthFinish.BearerTokenTypeReader.readField(parser, fieldName, tokenType);
                        continue;
                    }
                    if (fieldName.equals("access_token")) {
                        accessToken = DbxAuthFinish.AccessTokenReader.readField(parser, fieldName, accessToken);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (tokenType == null) {
                throw new JsonReadException("missing field \"token_type\"", top);
            }
            if (accessToken == null) {
                throw new JsonReadException("missing field \"access_token\"", top);
            }
            return accessToken;
        }
    };

    public DbxOAuth1Upgrader(DbxRequestConfig requestConfig, DbxAppInfo appInfo) {
        if (requestConfig == null) {
            throw new IllegalArgumentException("'requestConfig' is null");
        }
        if (appInfo == null) {
            throw new IllegalArgumentException("'appInfo' is null");
        }
        this.requestConfig = requestConfig;
        this.appInfo = appInfo;
    }

    public String createOAuth2AccessToken(DbxOAuth1AccessToken token) throws DbxException {
        if (token == null) {
            throw new IllegalArgumentException("'token' can't be null");
        }
        return DbxRequestUtil.doPostNoAuth(this.requestConfig, "Dropbox-Java-SDK", this.appInfo.getHost().getApi(), "1/oauth2/token_from_oauth1", null, this.getHeaders(token), new DbxRequestUtil.ResponseHandler<String>(){

            @Override
            public String handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(ResponseReader, response);
            }
        });
    }

    public void disableOAuth1AccessToken(DbxOAuth1AccessToken token) throws DbxException {
        if (token == null) {
            throw new IllegalArgumentException("'token' can't be null");
        }
        DbxRequestUtil.doPostNoAuth(this.requestConfig, "Dropbox-Java-SDK", this.appInfo.getHost().getApi(), "1/disable_access_token", null, this.getHeaders(token), new DbxRequestUtil.ResponseHandler<Void>(){

            @Override
            public Void handle(HttpRequestor.Response response) throws DbxException {
                if (response.getStatusCode() != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return null;
            }
        });
    }

    private ArrayList<HttpRequestor.Header> getHeaders(DbxOAuth1AccessToken token) {
        ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>(1);
        headers.add(new HttpRequestor.Header("Authorization", this.buildOAuth1Header(token)));
        return headers;
    }

    private String buildOAuth1Header(DbxOAuth1AccessToken token) {
        StringBuilder buf = new StringBuilder();
        buf.append("OAuth oauth_version=\"1.0\", oauth_signature_method=\"PLAINTEXT\"");
        buf.append(", oauth_consumer_key=\"").append(DbxOAuth1Upgrader.encode(this.appInfo.getKey())).append("\"");
        buf.append(", oauth_token=\"").append(DbxOAuth1Upgrader.encode(token.getKey())).append("\"");
        buf.append(", oauth_signature=\"").append(DbxOAuth1Upgrader.encode(this.appInfo.getSecret())).append("&").append(DbxOAuth1Upgrader.encode(token.getSecret())).append("\"");
        return buf.toString();
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw LangUtil.mkAssert("UTF-8 should always be supported", ex);
        }
    }
}

