/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InstanceBuilder<@UnknownKeyFor T> {
    private final @UnknownKeyFor @NonNull @Initialized Class<T> type;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> parameterTypes = new ArrayList();
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> arguments = new ArrayList<Object>();
    private @Nullable @UnknownKeyFor @Initialized String methodName;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> factoryClass;

    public static <T> @UnknownKeyFor @NonNull @Initialized InstanceBuilder<T> ofType(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        return new InstanceBuilder<T>(type);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized InstanceBuilder<T> ofType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> token) {
        Class<T> type = token.getRawType();
        return new InstanceBuilder<T>(type);
    }

    public @UnknownKeyFor @NonNull @Initialized InstanceBuilder<T> fromClassName(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        Preconditions.checkArgument((this.factoryClass == null ? 1 : 0) != 0, (Object)"Class name may only be specified once");
        if (name.indexOf(46) == -1) {
            name = this.type.getPackage().getName() + "." + name;
        }
        try {
            this.factoryClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(String.format("Could not find class: %s", name), e);
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized InstanceBuilder<T> fromClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> factoryClass) {
        this.factoryClass = factoryClass;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized InstanceBuilder<T> fromFactoryMethod(@UnknownKeyFor @NonNull @Initialized String methodName) {
        Preconditions.checkArgument((this.methodName == null ? 1 : 0) != 0, (Object)"Factory method name may only be specified once");
        this.methodName = methodName;
        return this;
    }

    public <ArgT> @UnknownKeyFor @NonNull @Initialized InstanceBuilder<T> withArg(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super ArgT> argType, ArgT value) {
        this.parameterTypes.add(argType);
        this.arguments.add(value);
        return this;
    }

    public T build() {
        if (this.factoryClass == null) {
            this.factoryClass = this.type;
        }
        Class[] types = this.parameterTypes.toArray(new Class[this.parameterTypes.size()]);
        if (this.methodName != null) {
            return this.buildFromMethod(types);
        }
        return this.buildFromConstructor(types);
    }

    private InstanceBuilder(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        this.type = type;
    }

    private T buildFromMethod(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] types) {
        Preconditions.checkState((this.factoryClass != null ? 1 : 0) != 0);
        Preconditions.checkState((this.methodName != null ? 1 : 0) != 0);
        try {
            Method method = this.factoryClass.getDeclaredMethod(this.methodName, types);
            Preconditions.checkState((boolean)Modifier.isStatic(method.getModifiers()), (Object)("Factory method must be a static method for " + this.factoryClass.getName() + "#" + method.getName()));
            Preconditions.checkState((boolean)this.type.isAssignableFrom(method.getReturnType()), (Object)("Return type for " + this.factoryClass.getName() + "#" + method.getName() + " must be assignable to " + this.type.getSimpleName()));
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object[] args = this.arguments.toArray(new Object[this.arguments.size()]);
            return this.type.cast(method.invoke(null, args));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Unable to find factory method %s#%s(%s)", this.factoryClass.getSimpleName(), this.methodName, Joiner.on((String)", ").join((Object[])types)));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(String.format("Encountered checked exception when constructing an instance from factory method %s#%s(%s)", this.factoryClass.getSimpleName(), this.methodName, Joiner.on((String)", ").join((Object[])types)), e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to construct instance from factory method %s#%s(%s) due to access restriction", this.factoryClass.getSimpleName(), this.methodName, Joiner.on((String)", ").join((Object[])types)), e);
        }
    }

    private T buildFromConstructor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] types) {
        Preconditions.checkState((this.factoryClass != null ? 1 : 0) != 0);
        try {
            Constructor<?> constructor = this.factoryClass.getDeclaredConstructor(types);
            Preconditions.checkState((boolean)this.type.isAssignableFrom(this.factoryClass), (Object)("Instance type " + this.factoryClass.getName() + " must be assignable to " + this.type.getSimpleName()));
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            Object[] args = this.arguments.toArray(new Object[this.arguments.size()]);
            return this.type.cast(constructor.newInstance(args));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find constructor for " + this.factoryClass.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to construct instance from constructor " + this.factoryClass.getName(), e);
        }
    }
}

