/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class IntervalWindow
extends BoundedWindow
implements Comparable<IntervalWindow> {
    private final @UnknownKeyFor @NonNull @Initialized Instant start;
    private final @UnknownKeyFor @NonNull @Initialized Instant end;

    public IntervalWindow(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized Instant end) {
        this.start = start;
        this.end = end;
    }

    public IntervalWindow(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized ReadableDuration size) {
        this.start = start;
        this.end = start.plus(size);
    }

    public @UnknownKeyFor @NonNull @Initialized Instant start() {
        return this.start;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant end() {
        return this.end;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp() {
        return this.end.minus((ReadableDuration)Duration.millis((long)1L));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized IntervalWindow other) {
        return !this.start.isAfter((ReadableInstant)other.start) && !this.end.isBefore((ReadableInstant)other.end);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDisjoint(@UnknownKeyFor @NonNull @Initialized IntervalWindow other) {
        return !this.end.isAfter((ReadableInstant)other.start) || !other.end.isAfter((ReadableInstant)this.start);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean intersects(@UnknownKeyFor @NonNull @Initialized IntervalWindow other) {
        return !this.isDisjoint(other);
    }

    public @UnknownKeyFor @NonNull @Initialized IntervalWindow span(@UnknownKeyFor @NonNull @Initialized IntervalWindow other) {
        return new IntervalWindow(new Instant(Math.min(this.start.getMillis(), other.start.getMillis())), new Instant(Math.max(this.end.getMillis(), other.end.getMillis())));
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        return o instanceof IntervalWindow && ((IntervalWindow)o).end.isEqual((ReadableInstant)this.end) && ((IntervalWindow)o).start.isEqual((ReadableInstant)this.start);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return (int)(this.start.getMillis() + (long)this.modInverse((int)(this.end.getMillis() << 1) + 1));
    }

    private @UnknownKeyFor @NonNull @Initialized int modInverse(@UnknownKeyFor @NonNull @Initialized int x) {
        int inverse = x * x * x;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        return inverse;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "[" + this.start + ".." + this.end + ")";
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized IntervalWindow o) {
        if (this.start.isEqual((ReadableInstant)o.start)) {
            return this.end.compareTo((ReadableInstant)o.end);
        }
        return this.start.compareTo((ReadableInstant)o.start);
    }

    public static @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> getCoder() {
        return IntervalWindowCoder.of();
    }

    public static class IntervalWindowCoder
    extends StructuredCoder<IntervalWindow> {
        private static final @UnknownKeyFor @NonNull @Initialized IntervalWindowCoder INSTANCE = new IntervalWindowCoder();
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Instant> instantCoder = InstantCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ReadableDuration> durationCoder = DurationCoder.of();

        public static @UnknownKeyFor @NonNull @Initialized IntervalWindowCoder of() {
            return INSTANCE;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized IntervalWindow window, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
            instantCoder.encode(window.end, outStream);
            durationCoder.encode((ReadableDuration)new Duration((ReadableInstant)window.start, (ReadableInstant)window.end), outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized IntervalWindow decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
            Instant end = instantCoder.decode(inStream);
            ReadableDuration duration = durationCoder.decode(inStream);
            return new IntervalWindow(end.minus(duration), end);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            instantCoder.verifyDeterministic();
            durationCoder.verifyDeterministic();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return instantCoder.consistentWithEquals() && durationCoder.consistentWithEquals();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized IntervalWindow value) {
            return instantCoder.isRegisterByteSizeObserverCheap(value.end) && durationCoder.isRegisterByteSizeObserverCheap((ReadableDuration)new Duration((ReadableInstant)value.start, (ReadableInstant)value.end));
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized IntervalWindow value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            instantCoder.registerByteSizeObserver(value.end, observer);
            durationCoder.registerByteSizeObserver((ReadableDuration)new Duration((ReadableInstant)value.start, (ReadableInstant)value.end), observer);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.emptyList();
        }
    }
}

