/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class RawUnionValue {
    private final @UnknownKeyFor @NonNull @Initialized int unionTag;
    private final @Nullable @UnknownKeyFor @Initialized Object value;

    public RawUnionValue(@UnknownKeyFor @NonNull @Initialized int unionTag, @Nullable @UnknownKeyFor @Initialized Object value) {
        this.unionTag = unionTag;
        this.value = value;
    }

    public @UnknownKeyFor @NonNull @Initialized int getUnionTag() {
        return this.unionTag;
    }

    public @Nullable @UnknownKeyFor @Initialized Object getValue() {
        return this.value;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.unionTag + ":" + this.value;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawUnionValue that = (RawUnionValue)o;
        if (this.unionTag != that.unionTag) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = this.unionTag;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

