/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.redshift;

import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.databases.postgresql.PostgreSqlDatabaseMeta;

@DatabaseMetaPlugin(type="REDSHIFT", typeDescription="Redshift", documentationUrl="/database/databases/redshift.html")
@GuiPlugin(id="GUI-RedshiftDatabaseMeta")
public class RedshiftDatabaseMeta
extends PostgreSqlDatabaseMeta {
    public RedshiftDatabaseMeta() {
        this.addExtraOption("REDSHIFT", "tcpKeepAlive", "true");
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 5439;
        }
        return -1;
    }

    public String getDriverClass() {
        return "com.amazon.redshift.jdbc42.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:redshift://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getExtraOptionsHelpText() {
        return "http://docs.aws.amazon.com/redshift/latest/mgmt/configure-jdbc-connection.html";
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean isSupportsSetMaxRows() {
        return false;
    }
}

