/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Objects;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.summary.ServerInfo;

public class InternalServerInfo
implements ServerInfo {
    private final String agent;
    private final String address;
    private final String version;
    private final String protocolVersion;

    public InternalServerInfo(String agent, BoltServerAddress address, ServerVersion version, BoltProtocolVersion protocolVersion) {
        this.agent = agent;
        this.address = address.toString();
        this.version = version.toString();
        this.protocolVersion = protocolVersion.toString();
    }

    @Override
    public String agent() {
        return this.agent;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public String protocolVersion() {
        return this.protocolVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalServerInfo that = (InternalServerInfo)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.version);
    }

    public String toString() {
        return "InternalServerInfo{address='" + this.address + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

