/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.IGuiRefresher;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionLambdaBuilder;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.hopgui.context.BaseGuiContextHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;

public class HopGuiPipelineContext
extends BaseGuiContextHandler
implements IGuiContextHandler {
    public static final String CONTEXT_ID = "HopGuiPipelineContext";
    private PipelineMeta pipelineMeta;
    private HopGuiPipelineGraph pipelineGraph;
    private Point click;
    private GuiActionLambdaBuilder<HopGuiPipelineContext> lambdaBuilder;

    public HopGuiPipelineContext(PipelineMeta pipelineMeta, HopGuiPipelineGraph pipelineGraph, Point click) {
        this.pipelineMeta = pipelineMeta;
        this.pipelineGraph = pipelineGraph;
        this.click = click;
        this.lambdaBuilder = new GuiActionLambdaBuilder();
    }

    @Override
    public String getContextId() {
        return CONTEXT_ID;
    }

    @Override
    public List<GuiAction> getSupportedActions() {
        ArrayList<GuiAction> actions = new ArrayList<GuiAction>();
        List<GuiAction> pluginActions = this.getPluginActions(true);
        if (pluginActions != null) {
            for (GuiAction pluginAction : pluginActions) {
                actions.add(this.lambdaBuilder.createLambda(pluginAction, (Object)this, (IGuiRefresher)this.pipelineGraph));
            }
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        List transformPlugins = registry.getPlugins(TransformPluginType.class);
        for (IPlugin transformPlugin : transformPlugins) {
            GuiAction createTransformAction = new GuiAction("pipeline-graph-create-transform-" + transformPlugin.getIds()[0], GuiActionType.Create, transformPlugin.getName(), transformPlugin.getDescription(), transformPlugin.getImageFile(), (shiftClicked, controlClicked, t) -> this.pipelineGraph.pipelineTransformDelegate.newTransform(this.pipelineMeta, transformPlugin.getIds()[0], transformPlugin.getName(), transformPlugin.getDescription(), controlClicked, true, this.click));
            createTransformAction.getKeywords().addAll(Arrays.asList(transformPlugin.getKeywords()));
            createTransformAction.setCategory(transformPlugin.getCategory());
            createTransformAction.setCategoryOrder("9999_" + transformPlugin.getCategory());
            try {
                createTransformAction.setClassLoader(registry.getClassLoader(transformPlugin));
            }
            catch (HopPluginException e) {
                LogChannel.UI.logError("Unable to get classloader for transform plugin " + transformPlugin.getIds()[0], (Throwable)e);
            }
            createTransformAction.getKeywords().add(transformPlugin.getCategory());
            actions.add(createTransformAction);
        }
        return actions;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }

    public HopGuiPipelineGraph getPipelineGraph() {
        return this.pipelineGraph;
    }

    public void setPipelineGraph(HopGuiPipelineGraph pipelineGraph) {
        this.pipelineGraph = pipelineGraph;
    }

    public Point getClick() {
        return this.click;
    }

    public void setClick(Point click) {
        this.click = click;
    }
}

