/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ShowMessageDialog
extends Dialog {
    private static final Class<?> PKG = ShowMessageDialog.class;
    private static final Map<Integer, String> buttonTextByFlagDefaults = new LinkedHashMap<Integer, String>();
    private String title;
    private String message;
    private Shell shell;
    private PropsUi props;
    private int flags;
    private final Map<Integer, String> buttonTextByFlag;
    private int returnValue;
    private int type;
    private Shell parent;
    private boolean scroll;
    private boolean hasIcon;
    private int timeOut;
    private List<Button> buttons;
    private FormLayout formLayout;
    private FormData fdlDesc;
    private Label wIcon;
    private Text wlDesc;

    public ShowMessageDialog(Shell parent, int flags, String title, String message) {
        this(parent, flags, title, message, false);
    }

    public ShowMessageDialog(Shell parent, int flags, String title, String message, boolean scroll) {
        this(parent, flags, buttonTextByFlagDefaults, title, message, scroll);
    }

    public ShowMessageDialog(Shell parent, int flags, Map<Integer, String> buttonTextByFlag, String title, String message, boolean scroll) {
        super(parent, 0);
        this.buttonTextByFlag = buttonTextByFlag;
        this.parent = parent;
        this.flags = flags;
        this.title = title;
        this.message = message;
        this.scroll = scroll;
        this.props = PropsUi.getInstance();
    }

    public int open() {
        Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 2160);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.formLayout = new FormLayout();
        this.shell.setLayout((Layout)this.formLayout);
        this.shell.setText(this.title);
        this.hasIcon = (this.flags & 8) != 0 || (this.flags & 2) != 0 || (this.flags & 4) != 0 || (this.flags & 1) != 0 || (this.flags & 0x10) != 0;
        Image image = null;
        if ((this.flags & 8) != 0) {
            image = display.getSystemImage(8);
        }
        if ((this.flags & 2) != 0) {
            image = display.getSystemImage(2);
        }
        if ((this.flags & 4) != 0) {
            image = display.getSystemImage(4);
        }
        if ((this.flags & 1) != 0) {
            image = display.getSystemImage(1);
        }
        if ((this.flags & 0x10) != 0) {
            image = display.getSystemImage(16);
        }
        this.hasIcon = this.hasIcon && image != null;
        this.wIcon = null;
        if (this.hasIcon) {
            this.wIcon = new Label((Composite)this.shell, 0);
            PropsUi.setLook((Widget)this.wIcon);
            this.wIcon.setImage(image);
            FormData fdIcon = new FormData();
            fdIcon.left = new FormAttachment(0, 0);
            fdIcon.top = new FormAttachment(0, 0);
            fdIcon.right = new FormAttachment(0, image.getBounds().width);
            fdIcon.bottom = new FormAttachment(0, image.getBounds().height);
            this.wIcon.setLayoutData((Object)fdIcon);
        }
        this.fdlDesc = new FormData();
        if (this.scroll) {
            this.wlDesc = new Text((Composite)this.shell, 778);
            this.shell.setSize(550, 350);
            this.fdlDesc.bottom = new FormAttachment(100, -70);
            this.fdlDesc.right = new FormAttachment(100, 0);
        } else {
            this.wlDesc = new Text((Composite)this.shell, 10);
            this.fdlDesc.right = new FormAttachment(100, 0);
        }
        this.wlDesc.setText(this.message);
        PropsUi.setLook((Widget)this.wlDesc);
        this.wlDesc.setLayoutData((Object)this.fdlDesc);
        this.buttons = new ArrayList<Button>();
        ArrayList<1> adapters = new ArrayList<1>();
        for (Map.Entry<Integer, String> entry : this.buttonTextByFlag.entrySet()) {
            final Integer buttonFlag = entry.getKey();
            if ((this.flags & buttonFlag) == 0) continue;
            Button button = new Button((Composite)this.shell, 8);
            button.setText(entry.getValue());
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ShowMessageDialog.this.quit(buttonFlag);
                }
            };
            button.addSelectionListener((SelectionListener)selectionAdapter);
            adapters.add(selectionAdapter);
            this.buttons.add(button);
        }
        this.setLayoutAccordingToType();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShowMessageDialog.this.cancel();
            }
        });
        if (!this.scroll) {
            BaseTransformDialog.setSize(this.shell);
        }
        Button button = this.buttons.get(0);
        SelectionAdapter selectionAdapter = (SelectionAdapter)adapters.get(0);
        String ok = button.getText();
        long startTime = new Date().getTime();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
            if (this.timeOut <= 0) continue;
            long time = new Date().getTime();
            long diff = (time - startTime) / 1000L;
            button.setText(ok + " (" + ((long)this.timeOut - diff) + ")");
            if (diff < (long)this.timeOut) continue;
            selectionAdapter.widgetSelected(null);
        }
        return this.returnValue;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void cancel() {
        if ((this.flags & 0x80) > 0) {
            this.quit(128);
        } else {
            this.quit(256);
        }
    }

    private void quit(int returnValue) {
        this.returnValue = returnValue;
        this.dispose();
    }

    private void setLayoutAccordingToType() {
        ShowMessageDialog showMessageDialog = this;
        int margin = showMessageDialog.props.getMargin();
        switch (this.type) {
            case 1: {
                this.formLayout.marginWidth = 15;
                this.formLayout.marginHeight = 15;
                this.setFdlDesc(margin * 3, 0, 0, margin);
                BaseTransformDialog.positionBottomButtons((Composite)this.shell, this.buttons.toArray(new Button[this.buttons.size()]), 0, 2, (Control)this.wlDesc);
                break;
            }
            default: {
                this.formLayout.marginWidth = PropsUi.getFormMargin();
                this.formLayout.marginHeight = PropsUi.getFormMargin();
                this.setFdlDesc(margin * 2, margin, 0, margin);
                BaseTransformDialog.positionBottomButtons((Composite)this.shell, this.buttons.toArray(new Button[this.buttons.size()]), margin, (Control)this.wlDesc);
            }
        }
    }

    private void setFdlDesc(int leftOffsetHasIcon, int topOffsetHasIcon, int leftOffsetNoIcon, int topOffsetNoIcon) {
        if (this.hasIcon) {
            this.fdlDesc.left = new FormAttachment((Control)this.wIcon, leftOffsetHasIcon);
            this.fdlDesc.top = new FormAttachment(0, topOffsetHasIcon);
        } else {
            this.fdlDesc.left = new FormAttachment(0, leftOffsetNoIcon);
            this.fdlDesc.top = new FormAttachment(0, topOffsetNoIcon);
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public void setType(int type) {
        this.type = type;
    }

    static {
        buttonTextByFlagDefaults.put(32, BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        buttonTextByFlagDefaults.put(256, BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        buttonTextByFlagDefaults.put(64, BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]));
        buttonTextByFlagDefaults.put(128, BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0]));
    }
}

