/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import org.apache.hop.core.util.Assert;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

public class SimpleFileSelection
extends SelectionAdapter {
    public static final String DEFAULT_FILTER_EXTENSION = "*";
    public static final String DEFAULT_FILTER_NAME = "All files (*.*)";
    private final Shell shell;
    private final TextVar textVar;
    private final String[] filterExtensions;
    private final String[] filterNames;

    public SimpleFileSelection(Shell shell, TextVar textVar, String[] filterExtensions, String[] filterNames) throws IllegalArgumentException {
        Assert.assertNotNull((Object)shell, (String)"Shell cannot be null");
        Assert.assertNotNull((Object)((Object)textVar), (String)"Text var cannot be null");
        Assert.assertNotNull((Object)filterNames, (String)"Filter names cannot be null");
        Assert.assertNotNull((Object)filterExtensions, (String)"Filter extensions cannot be null");
        this.shell = shell;
        this.textVar = textVar;
        this.filterExtensions = new String[filterExtensions.length];
        System.arraycopy(filterExtensions, 0, this.filterExtensions, 0, filterExtensions.length);
        this.filterNames = new String[filterNames.length];
        System.arraycopy(filterNames, 0, this.filterNames, 0, filterNames.length);
    }

    public SimpleFileSelection(Shell shell, TextVar textVar) throws IllegalArgumentException {
        this(shell, textVar, new String[]{DEFAULT_FILTER_EXTENSION}, new String[]{DEFAULT_FILTER_NAME});
    }

    public SimpleFileSelection(Shell shell, TextVar textVar, String ... filterNames) throws IllegalArgumentException {
        this(shell, textVar, new String[]{DEFAULT_FILTER_EXTENSION}, filterNames);
    }

    public void widgetSelected(SelectionEvent event) {
        BaseDialog.presentFileDialog(this.shell, this.textVar, null, null, this.filterExtensions, this.filterNames, true);
    }
}

