/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import org.apache.hop.ui.core.dialog.EnterPrintDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintSpool {
    private PrinterData printerdata = Printer.getDefaultPrinterData();
    private Printer printer;

    public PrintSpool() {
        if (this.printerdata != null) {
            this.printer = new Printer(this.printerdata);
        }
    }

    public PrinterData getPrinterData() {
        return this.printerdata;
    }

    public Printer getPrinter(Shell sh) {
        PrintDialog pd = new PrintDialog(sh);
        this.printerdata = pd.open();
        if (this.printerdata != null) {
            if (this.printer != null) {
                this.printer.dispose();
            }
            this.printer = new Printer(this.printerdata);
        }
        return this.printer;
    }

    public void dispose() {
        if (this.printer != null) {
            this.printer.dispose();
        }
    }

    public int getDepth() {
        return this.printer.getDepth();
    }

    public PaletteData getPaletteData() {
        PaletteData palette;
        switch (this.getDepth()) {
            case 1: {
                palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
                break;
            }
            default: {
                palette = new PaletteData(0, 0, 0);
                palette.isDirect = true;
            }
        }
        return palette;
    }

    public void printImage(Shell sh, Image img) {
        if (this.printerdata != null) {
            double marginBottom;
            double marginTop;
            double marginRight;
            double marginLeft;
            Rectangle imgbounds = img.getBounds();
            Point max = new Point(imgbounds.width, imgbounds.height);
            Point dpiPrinter = this.printer.getDPI();
            Point dpiScreen = Display.getCurrent().getDPI();
            double factorx = (double)dpiPrinter.x / (double)dpiScreen.x;
            double factory = (double)dpiPrinter.y / (double)dpiScreen.y;
            Rectangle page = this.printer.getBounds();
            EnterPrintDialog epd = new EnterPrintDialog(sh, 1, 1, 100, factorx, factory, page, marginLeft = 0.4, marginRight = 0.4, marginTop = 0.4, marginBottom = 0.4, img);
            if (epd.open() == 32) {
                double pageLeft = epd.leftMargin * (double)dpiPrinter.x;
                double pageRight = epd.rightMargin * (double)dpiPrinter.x;
                double pageTop = epd.topMargin * (double)dpiPrinter.y;
                double pageBottom = epd.bottomMargin * (double)dpiPrinter.y;
                double pageSizex = (double)page.width - pageLeft - pageRight;
                double pageSizey = (double)page.height - pageTop - pageBottom;
                double sizeOnPaperx = (double)max.x * factorx;
                double sizeOnPapery = (double)max.y * factory;
                double actualSizex = sizeOnPaperx * (double)epd.scale / 100.0;
                double actualSizey = sizeOnPapery * (double)epd.scale / 100.0;
                this.printer.startJob("HopGui : print workflow");
                for (int c = 0; c < epd.nrcols; ++c) {
                    double leftToPrintX = actualSizex - pageSizex * (double)c;
                    double printx = leftToPrintX > pageSizex ? pageSizex : (leftToPrintX >= 0.0 ? leftToPrintX : 0.0);
                    for (int r = 0; r < epd.nrrows; ++r) {
                        double leftToPrintY = actualSizey - pageSizey * (double)r;
                        double printy = leftToPrintY > pageSizey ? pageSizey : (leftToPrintY >= 0.0 ? leftToPrintY : 0.0);
                        int startx = (int)(actualSizex - leftToPrintX);
                        int starty = (int)(actualSizey - leftToPrintY);
                        int fromx = (int)((double)startx / (factorx * (double)epd.scale / 100.0));
                        int fromy = (int)((double)starty / (factory * (double)epd.scale / 100.0));
                        int imx = (int)((double)max.x * printx / actualSizex) - 1;
                        int imy = (int)((double)max.y * printy / actualSizey) - 1;
                        this.printer.startPage();
                        GC gcPrinter = new GC((Drawable)this.printer);
                        gcPrinter.drawImage(img, fromx, fromy, imx, imy, (int)pageLeft, (int)pageTop, (int)printx, (int)printy);
                        System.out.println("img dept = " + img.getImageData().depth);
                        System.out.println("prn dept = " + this.printer.getDepth());
                        System.out.println("img size = (" + img.getBounds().x + "," + img.getBounds().y + ") : (" + img.getBounds().width + "," + img.getBounds().height + ")");
                        System.out.println("fromx=" + fromx + ", fromy=" + fromy + ", imx=" + imx + ", imy=" + imy + ", pageLeft=" + (int)pageLeft + ", page_top=" + (int)pageTop + ", printx=" + (int)printx + ", printy=" + (int)printy);
                        this.printer.endPage();
                        gcPrinter.dispose();
                    }
                }
                this.printer.endJob();
                this.printer.dispose();
            }
            img.dispose();
        }
    }
}

