/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.AbstractID;

public class ExecutionAttemptID
implements Serializable {
    private static final long serialVersionUID = -1169683445778281344L;
    private static final int BYTEBUF_LEN = 16;
    private final AbstractID executionAttemptId;

    public ExecutionAttemptID() {
        this(new AbstractID());
    }

    private ExecutionAttemptID(AbstractID id) {
        this.executionAttemptId = id;
    }

    @VisibleForTesting
    public ExecutionAttemptID(ExecutionAttemptID toCopy) {
        this.executionAttemptId = new AbstractID(toCopy.executionAttemptId);
    }

    public void writeTo(ByteBuf buf) {
        buf.writeLong(this.executionAttemptId.getLowerPart());
        buf.writeLong(this.executionAttemptId.getUpperPart());
    }

    public static ExecutionAttemptID fromByteBuf(ByteBuf buf) {
        return new ExecutionAttemptID(new AbstractID(buf.readLong(), buf.readLong()));
    }

    public static int getByteBufLength() {
        return 16;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ExecutionAttemptID that = (ExecutionAttemptID)obj;
            return that.executionAttemptId.equals((Object)this.executionAttemptId);
        }
        return false;
    }

    public int hashCode() {
        return this.executionAttemptId.hashCode();
    }

    public String toString() {
        return this.executionAttemptId.toString();
    }
}

