/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.ValueAndCoderLazySerializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BoundedDataset<@UnknownKeyFor T>
implements Dataset {
    private transient @Nullable @UnknownKeyFor @Initialized JavaSparkContext jsc;
    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> windowedValues;
    private @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> rdd;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> clientBytes;

    BoundedDataset(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> rdd) {
        this.rdd = rdd;
    }

    BoundedDataset(@UnknownKeyFor @NonNull @Initialized Iterable<T> values, @UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        this.windowedValues = Iterables.transform(values, WindowedValue::valueInGlobalWindow);
        this.jsc = jsc;
        this.coder = coder;
    }

    public @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getRDD() {
        if (this.rdd == null) {
            WindowedValue.ValueOnlyWindowedValueCoder windowCoder = WindowedValue.getValueOnlyCoder(this.coder);
            this.rdd = this.jsc.parallelize(CoderHelpers.toByteArrays(this.windowedValues, windowCoder)).map(CoderHelpers.fromByteFunction(windowCoder));
        }
        return this.rdd;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getBytes(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<T> wvCoder) {
        if (this.clientBytes == null) {
            JavaRDD bytesRDD = this.rdd.map(CoderHelpers.toByteFunction(wvCoder));
            this.clientBytes = bytesRDD.collect();
        }
        return this.clientBytes;
    }

    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getValues(@UnknownKeyFor @NonNull @Initialized PCollection<T> pcollection) {
        if (this.windowedValues == null) {
            WindowFn windowFn = pcollection.getWindowingStrategy().getWindowFn();
            Coder windowCoder = windowFn.windowCoder();
            Object windowedValueCoder = windowFn instanceof GlobalWindows ? WindowedValue.ValueOnlyWindowedValueCoder.of((Coder)pcollection.getCoder()) : WindowedValue.FullWindowedValueCoder.of((Coder)pcollection.getCoder(), (Coder)windowCoder);
            JavaRDD bytesRDD = this.rdd.map(CoderHelpers.toByteFunction(windowedValueCoder));
            List clientBytes = bytesRDD.collect();
            this.windowedValues = clientBytes.stream().map(arg_0 -> BoundedDataset.lambda$getValues$0((WindowedValue.WindowedValueCoder)windowedValueCoder, arg_0)).collect(Collectors.toList());
        }
        return this.windowedValues;
    }

    @Override
    public void cache(@UnknownKeyFor @NonNull @Initialized String storageLevel, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        StorageLevel level = StorageLevel.fromString((String)storageLevel);
        if (TranslationUtils.canAvoidRddSerialization(level)) {
            this.rdd = this.getRDD().persist(level);
        } else {
            Coder<?> windowedValueCoder = coder;
            this.rdd = this.getRDD().map((Function & Serializable)v -> ValueAndCoderLazySerializable.of(v, windowedValueCoder)).persist(level).map((Function & Serializable)v -> (WindowedValue)v.getOrDecode(windowedValueCoder));
        }
    }

    @Override
    public void action() {
        this.rdd.foreach(TranslationUtils.emptyVoidFunction());
    }

    @Override
    public void setName(@UnknownKeyFor @NonNull @Initialized String name) {
        this.getRDD().setName(name);
    }

    private static /* synthetic */ WindowedValue lambda$getValues$0(WindowedValue.WindowedValueCoder windowedValueCoder, byte[] bytes) {
        return (WindowedValue)CoderHelpers.fromByteArray(bytes, windowedValueCoder);
    }
}

