/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.SparkCommonPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DoFnPartitionIteratorFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SideInputValues;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SparkSideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.functions;
import org.apache.spark.storage.StorageLevel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag;

class ParDoTranslatorBatch<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends TransformTranslator<PCollection<? extends InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> {
    private static final @UnknownKeyFor @NonNull @Initialized ClassTag<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Object>> WINDOWED_VALUE_CTAG = ClassTag.apply(WindowedValue.class);
    private static final @UnknownKeyFor @NonNull @Initialized ClassTag<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Object>>> TUPLE2_CTAG = ClassTag.apply(Tuple2.class);

    ParDoTranslatorBatch() {
        super(0.2f);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform) {
        DoFn doFn = transform.getFn();
        DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
        Preconditions.checkState((!signature.processElement().isSplittable() ? 1 : 0) != 0, (String)"Not expected to directly translate splittable DoFn, should have been overridden: %s", (Object)doFn);
        Preconditions.checkState((!signature.usesState() && !signature.usesTimers() ? 1 : 0) != 0, (Object)"States and timers are not supported for the moment.");
        Preconditions.checkState((signature.onWindowExpiration() == null ? 1 : 0) != 0, (String)"onWindowExpiration is not supported: %s", (Object)doFn);
        Preconditions.checkState((!signature.processElement().requiresTimeSortedInput() ? 1 : 0) != 0, (Object)"@RequiresTimeSortedInput is not supported for the moment");
        SparkSideInputReader.validateMaterializations(transform.getSideInputs().values());
        return true;
    }

    @Override
    public void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PCollection input = (PCollection)cxt.getInput();
        Dataset inputDs = cxt.getDataset(input);
        SideInputReader sideInputReader = this.createSideInputReader(transform.getSideInputs().values(), cxt);
        MetricsAccumulator metrics = MetricsAccumulator.getInstance(cxt.getSparkSession());
        TupleTag mainOut = transform.getMainOutputTag();
        Map outputs = Maps.filterEntries(cxt.getOutputs(), e -> e != null && (((TupleTag)e.getKey()).equals((Object)mainOut) || !cxt.isLeaf((PCollection)e.getValue())));
        if (outputs.size() > 1) {
            Map<String, Integer> tagColIdx = this.tagsColumnIndex(outputs.keySet());
            List encoders = this.createEncoders(outputs, tagColIdx, cxt);
            DoFnPartitionIteratorFactory doFnMapper = DoFnPartitionIteratorFactory.multiOutput(cxt.getCurrentTransform(), cxt.getOptionsSupplier(), input, sideInputReader, metrics, tagColIdx);
            SparkCommonPipelineOptions opts = (SparkCommonPipelineOptions)cxt.getOptions().as(SparkCommonPipelineOptions.class);
            StorageLevel storageLevel = StorageLevel.fromString((String)opts.getStorageLevel());
            if (StorageLevel.MEMORY_ONLY().equals((Object)storageLevel)) {
                RDD allTagsRDD = inputDs.rdd().mapPartitions(doFnMapper, false, TUPLE2_CTAG);
                allTagsRDD.persist();
                for (TupleTag tag : outputs.keySet()) {
                    int colIdx = (Integer)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)tagColIdx.get(tag.getId()), (Object)"Unknown tag");
                    RDD rddByTag = allTagsRDD.flatMap(ParDoTranslatorBatch.selectByColumnIdx(colIdx), WINDOWED_VALUE_CTAG);
                    cxt.putDataset(cxt.getOutput(tag), cxt.getSparkSession().createDataset(rddByTag, encoders.get(colIdx)), false);
                }
            } else {
                Dataset allTagsDS = inputDs.mapPartitions(doFnMapper, EncoderHelpers.oneOfEncoder(encoders));
                allTagsDS.persist(storageLevel);
                for (TupleTag tag : outputs.keySet()) {
                    int colIdx = (Integer)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)tagColIdx.get(tag.getId()), (Object)"Unknown tag");
                    TypedColumn col = functions.col((String)Integer.toString(colIdx)).as(encoders.get(colIdx));
                    cxt.putDataset(cxt.getOutput(tag), allTagsDS.filter(col.isNotNull()).select(col), false);
                }
            }
        } else {
            PCollection output = cxt.getOutput(mainOut);
            DoFnPartitionIteratorFactory doFnMapper = DoFnPartitionIteratorFactory.singleOutput(cxt.getCurrentTransform(), cxt.getOptionsSupplier(), input, sideInputReader, metrics);
            Dataset mainDS = inputDs.mapPartitions(doFnMapper, cxt.windowedEncoder(output.getCoder()));
            cxt.putDataset(output, mainDS);
        }
    }

    static <T> @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Integer, T>, @UnknownKeyFor @NonNull @Initialized TraversableOnce<T>> selectByColumnIdx(@UnknownKeyFor @NonNull @Initialized int idx) {
        return t -> idx == (Integer)t._1 ? ScalaInterop.listOf(t._2) : ScalaInterop.emptyList();
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> tagsColumnIndex(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> tags) {
        HashMap index = Maps.newHashMapWithExpectedSize((int)tags.size());
        for (TupleTag<?> tag : tags) {
            index.put(tag.getId(), index.size());
        }
        return index;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Object>>> createEncoders(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> tagIdColIdx, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context ctx) {
        ArrayList<Encoder<WindowedValue<Object>>> encoders = new ArrayList<Encoder<WindowedValue<Object>>>(outputs.size());
        for (Map.Entry<TupleTag<?>, PCollection<?>> e : outputs.entrySet()) {
            Encoder enc = ctx.windowedEncoder(e.getValue().getCoder());
            int colIdx = (Integer)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)tagIdColIdx.get(e.getKey().getId()));
            encoders.add(colIdx, enc);
        }
        return encoders;
    }

    private <T> @UnknownKeyFor @NonNull @Initialized SideInputReader createSideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformTranslator. @UnknownKeyFor @NonNull @Initialized Context cxt) {
        if (views.isEmpty()) {
            return SparkSideInputReader.empty();
        }
        HashMap broadcasts = Maps.newHashMapWithExpectedSize((int)views.size());
        for (PCollectionView<?> view : views) {
            PCollection pCol = (PCollection)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)view.getPCollection());
            Broadcast broadcast = cxt.getSideInputBroadcast(pCol, SideInputValues.loader(pCol));
            broadcasts.put(view.getTagInternal().getId(), broadcast);
        }
        return SparkSideInputReader.create(broadcasts);
    }
}

