/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class Property
implements Cloneable {
    @HopMetadataProperty
    private String alias;
    @HopMetadataProperty
    private String name;
    @HopMetadataProperty
    private String expression;
    @HopMetadataProperty
    private String parameter;
    @HopMetadataProperty
    private String rename;
    @HopMetadataProperty
    private boolean descending;

    public Property() {
    }

    public Property(String alias, String name, String expression, String parameter, String rename, boolean descending) {
        this.alias = alias;
        this.name = name;
        this.expression = expression;
        this.parameter = parameter;
        this.rename = rename;
        this.descending = descending;
    }

    public Property(String alias, String name, String expression, String parameter, String rename) {
        this(alias, name, expression, parameter, rename, false);
    }

    public Property(String alias, String name, String parameter) {
        this(alias, name, null, parameter, null, false);
    }

    public Property(String name, String parameter) {
        this(null, name, null, parameter, null, false);
    }

    public Property(Property p) {
        this.alias = p.alias;
        this.name = p.name;
        this.expression = p.expression;
        this.parameter = p.parameter;
        this.rename = p.rename;
        this.descending = p.descending;
    }

    public Property clone() {
        return new Property(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return Objects.equals(this.alias, property.alias) && Objects.equals(this.name, property.name) && Objects.equals(this.expression, property.expression) && Objects.equals(this.parameter, property.parameter) && Objects.equals(this.rename, property.rename);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.name, this.expression, this.parameter, this.rename);
    }

    public String formatParameter(String unwindAlias) {
        if (StringUtils.isEmpty((String)unwindAlias)) {
            return "{" + this.parameter + "}";
        }
        return unwindAlias + "." + this.parameter;
    }

    public String getOrderByCypherClause() {
        Object cypher = StringUtils.isEmpty((String)this.expression) ? this.alias + "." + this.name : this.expression;
        if (this.descending) {
            cypher = (String)cypher + " DESC";
        }
        return cypher;
    }

    public String getSetCypherClause(String unwindAlias) {
        String cypher = this.alias + "." + this.name + "=";
        cypher = StringUtils.isEmpty((String)this.expression) ? (StringUtils.isEmpty((String)unwindAlias) ? cypher + "{" + this.parameter + "}" : cypher + unwindAlias + "." + this.parameter) : cypher + this.expression;
        return cypher;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }
}

