/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureCliSubscription;
import com.microsoft.azure.credentials.AzureCliToken;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.rest.serializer.JacksonAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Beta
public final class AzureCliCredentials
extends AzureTokenCredentials {
    private static final ObjectMapper MAPPER = new JacksonAdapter().serializer().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd hh:mm:ssssss"));
    private Map<String, AzureCliSubscription> subscriptions;
    private File azureProfile;
    private File accessTokens;
    private Lock lock = new ReentrantLock();

    private AzureCliCredentials() {
        super(null, null);
        this.subscriptions = new ConcurrentHashMap<String, AzureCliSubscription>();
    }

    private synchronized void loadAccessTokens() throws IOException {
        try {
            AzureCliSubscription.Wrapper wrapper = (AzureCliSubscription.Wrapper)MAPPER.readValue(this.azureProfile, AzureCliSubscription.Wrapper.class);
            List tokens = (List)MAPPER.readValue(this.accessTokens, (TypeReference)new TypeReference<List<AzureCliToken>>(){});
            while (wrapper == null || tokens == null || tokens.isEmpty() || wrapper.subscriptions == null || wrapper.subscriptions.isEmpty()) {
                System.err.println("Please login in Azure CLI and press any key to continue after you've successfully logged in.");
                System.in.read();
                wrapper = (AzureCliSubscription.Wrapper)MAPPER.readValue(this.azureProfile, AzureCliSubscription.Wrapper.class);
                tokens = (List)MAPPER.readValue(this.accessTokens, (TypeReference)new TypeReference<List<AzureCliToken>>(){});
            }
            for (AzureCliSubscription subscription : wrapper.subscriptions) {
                for (AzureCliToken token : tokens) {
                    if (subscription.isServicePrincipal() != token.isServicePrincipal() || !subscription.userName().equalsIgnoreCase(token.user()) || !subscription.tenant().equalsIgnoreCase(token.tenant())) continue;
                    this.subscriptions.put(subscription.id(), subscription.withToken(token));
                    if (!subscription.isDefault()) continue;
                    this.withDefaultSubscriptionId(subscription.id());
                }
            }
        }
        catch (IOException e) {
            System.err.println(String.format("Cannot read files %s and %s. Are you logged in Azure CLI?", this.azureProfile.getAbsolutePath(), this.accessTokens.getAbsolutePath()));
            throw e;
        }
    }

    public static AzureCliCredentials create() throws IOException {
        return AzureCliCredentials.create(Paths.get(System.getProperty("user.home"), ".azure", "azureProfile.json").toFile(), Paths.get(System.getProperty("user.home"), ".azure", "accessTokens.json").toFile());
    }

    public static AzureCliCredentials create(File azureProfile, File accessTokens) throws IOException {
        AzureCliCredentials credentials = new AzureCliCredentials();
        credentials.azureProfile = azureProfile;
        credentials.accessTokens = accessTokens;
        credentials.loadAccessTokens();
        return credentials;
    }

    public String clientId() {
        return this.subscriptions.get(this.defaultSubscriptionId()).clientId();
    }

    public String domain() {
        return this.subscriptions.get(this.defaultSubscriptionId()).tenant();
    }

    public AzureEnvironment environment() {
        return this.subscriptions.get(this.defaultSubscriptionId()).environment();
    }

    public synchronized String getToken(String resource) throws IOException {
        String token = this.subscriptions.get(this.defaultSubscriptionId()).credentialInstance().getToken(resource);
        if (token == null) {
            System.err.println("Please login in Azure CLI and press any key to continue after you've successfully logged in.");
            System.in.read();
            this.loadAccessTokens();
            token = this.subscriptions.get(this.defaultSubscriptionId()).credentialInstance().getToken(resource);
        }
        return token;
    }
}

