/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;

class ClientSideStatements {
    private static final String GSQL_STATEMENTS_DEFINITION_FILE = "ClientSideStatements.json";
    private static final String PG_STATEMENTS_DEFINITION_FILE = "PG_ClientSideStatements.json";
    private static final ClientSideStatements GSQL_STATEMENTS = ClientSideStatements.importGsqlStatements();
    private static final ClientSideStatements PG_STATEMENTS = ClientSideStatements.importPgStatements();
    private Set<ClientSideStatementImpl> statements;

    static ClientSideStatements getInstance(Dialect dialect) {
        switch (dialect) {
            case GOOGLE_STANDARD_SQL: {
                return GSQL_STATEMENTS;
            }
            case POSTGRESQL: {
                return PG_STATEMENTS;
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown or unsupported dialect: " + (Object)((Object)dialect));
    }

    private static ClientSideStatements importGsqlStatements() {
        Gson gson = new Gson();
        return (ClientSideStatements)gson.fromJson((Reader)new InputStreamReader(ClientSideStatements.class.getResourceAsStream(GSQL_STATEMENTS_DEFINITION_FILE)), ClientSideStatements.class);
    }

    private static ClientSideStatements importPgStatements() {
        Gson gson = new Gson();
        return (ClientSideStatements)gson.fromJson((Reader)new InputStreamReader(ClientSideStatements.class.getResourceAsStream(PG_STATEMENTS_DEFINITION_FILE)), ClientSideStatements.class);
    }

    private ClientSideStatements() {
    }

    Set<ClientSideStatementImpl> getCompiledStatements() throws ClientSideStatementImpl.CompileException {
        for (ClientSideStatementImpl statement : this.statements) {
            statement.compile();
        }
        return this.statements;
    }
}

