/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.Comparator;
import org.apache.hop.core.Const;

public class ObjectUsageCount
implements Comparator<ObjectUsageCount>,
Comparable<ObjectUsageCount> {
    private String objectName;
    private int nrUses;

    public ObjectUsageCount(String objectName, int nrUses) {
        this.objectName = objectName;
        this.nrUses = nrUses;
    }

    public String toString() {
        return this.objectName + ";" + this.nrUses;
    }

    public static ObjectUsageCount fromString(String string) {
        String[] splits = string.split(";");
        if (splits.length >= 2) {
            return new ObjectUsageCount(splits[0], Const.toInt(splits[1], 1));
        }
        return new ObjectUsageCount(string, 1);
    }

    @Override
    public int compare(ObjectUsageCount count1, ObjectUsageCount count2) {
        return count1.compareTo(count2);
    }

    @Override
    public int compareTo(ObjectUsageCount count) {
        return Integer.valueOf(count.getNrUses()).compareTo(this.getNrUses());
    }

    public void reset() {
        this.nrUses = 0;
    }

    public int increment() {
        ++this.nrUses;
        return this.nrUses;
    }

    public int getNrUses() {
        return this.nrUses;
    }

    public void setNrUses(int nrUses) {
        this.nrUses = nrUses;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }
}

